/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadCheckinHandlerFactory
extends CheckinHandlerFactory {
    private static final Logger LOG = Logger.getInstance((String)UploadCheckinHandlerFactory.class.getName());

    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory", "createHandler"));
        }
        if (commitContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory", "createHandler"));
        }
        final PublishConfig publishConfig = PublishConfig.getInstance(panel.getProject());
        CheckinHandler checkinHandler = new CheckinHandler(){
            private final Ref<Pair<String, String>> myTempSelectedServerIdAndName = new Ref();

            public RefreshableOnComponent getAfterCheckinConfigurationPanel(Disposable parentDisposable) {
                JLabel label = new JLabel(WDBundle.message("upload.on.checkin.checkbox.label", new Object[0]));
                final WebServerCombo combo = new WebServerCombo(true, -1, true);
                final JCheckBox checkBox = new JCheckBox(WDBundle.message("always.use.selected.server", new Object[0]));
                Disposer.register((Disposable)parentDisposable, (Disposable)combo);
                combo.setProject(panel.getProject());
                BorderLayout layout = new BorderLayout();
                layout.setVgap(3);
                final JPanel panel2 = new JPanel(layout);
                panel2.add((Component)label, "North");
                panel2.add((Component)((Object)combo), "Center");
                panel2.add((Component)checkBox, "South");
                return new RefreshableOnComponent(){

                    public JComponent getComponent() {
                        return panel2;
                    }

                    public void refresh() {
                        if (publishConfig.isPersistUploadOnCheckin()) {
                            combo.reset(publishConfig.getUploadOnCheckin());
                            checkBox.setSelected(true);
                        } else {
                            combo.reset((Pair<String, String>)((Pair)myTempSelectedServerIdAndName.get()));
                            checkBox.setSelected(false);
                        }
                    }

                    public void saveState() {
                        if (checkBox.isSelected()) {
                            publishConfig.setPersistUploadOnCheckin(true);
                            publishConfig.setUploadOnCheckin(combo.getSelectedServer());
                            myTempSelectedServerIdAndName.set(null);
                        } else {
                            publishConfig.setPersistUploadOnCheckin(false);
                            publishConfig.setUploadOnCheckin(null);
                            myTempSelectedServerIdAndName.set(combo.getSelectedIdAndName());
                        }
                    }

                    public void restoreState() {
                        this.refresh();
                    }
                };
            }

            public void checkinSuccessful() {
                Pair idAndName = publishConfig.isPersistUploadOnCheckin() ? publishConfig.getUploadOnCheckin() : (Pair)this.myTempSelectedServerIdAndName.get();
                if (idAndName == null) {
                    return;
                }
                WebServerConfig server = WebServersConfigManager.getInstance(panel.getProject()).findServer((String)idAndName.first);
                if (server == null || !server.needsTransfer() || server.getFileTransferConfig().validateFast() != null) {
                    return;
                }
                FileTransferToolWindow.printWithTimestamp(panel.getProject(), server, WDBundle.message("upload.on.commit", server.getName(), panel.getCommitMessage()), ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig.getTraceLevel());
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (panel == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory$1", "lambda$checkinSuccessful$0"));
                    }
                    Project project = panel.getProject();
                    ProgressManager.getInstance().run((Task)new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, publishConfig, Deployable.create(server), WDBundle.message("upload.to", server.getName()), true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){

                        @Override
                        protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                            return UploadCheckinHandlerFactory.doScanFiles(context, panel.getSelectedChanges());
                        }
                    });
                });
            }
        };
        if (checkinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory", "createHandler"));
        }
        return checkinHandler;
    }

    public static TransferTask.ListBased.ResultWithErrors doScanFiles(ExecutionContext context, Collection<Change> changes) throws FileSystemException {
        ArrayList<ChangeInfo> changeInfos = new ArrayList<ChangeInfo>(changes.size());
        for (Change change : changes) {
            changeInfos.add(new ChangeInfo(change));
        }
        Collections.sort(changeInfos);
        ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
        ArrayList<String> errors = new ArrayList<String>();
        for (ChangeInfo change : changeInfos) {
            context.getProgressIndicator().checkCanceled();
            String itemPath = change.beforePath != null && !context.getConfig().isExcludedByName(change.beforePath) ? change.beforePath : change.afterPath;
            context.getProgressIndicator().setText(WDBundle.message("processing.0", itemPath));
            try {
                UploadCheckinHandlerFactory.processChange(change, context, result);
            }
            catch (FileSystemException e) {
                if (context.getConfig().isStopOnFirstError() || changeInfos.size() == 1 || PublishUtils.isFatal(e)) {
                    throw e;
                }
                LOG.warn((Throwable)e);
                errors.add(WDBundle.message("failed.to.process.change", itemPath, PublishUtils.getMessage(e, false)));
            }
        }
        return new TransferTask.ListBased.ResultWithErrors(result, DeploymentPathUtils.ErrorsAndExclusions.reportErrors(errors));
    }

    private static void processChange(ChangeInfo change, ExecutionContext context, List<TransferOperation> result) throws FileSystemException {
        if (change.beforePath == null || context.getConfig().isExcludedByName(change.beforePath)) {
            UploadCheckinHandlerFactory.processCreate(context, result, change.afterPath, change.isDirectory);
        } else if (change.afterPath == null || context.getConfig().isExcludedByName(change.afterPath)) {
            UploadCheckinHandlerFactory.processDelete(context, result, change.beforePath, change.isDirectory);
        } else {
            DeploymentPathMapping mappingBefore = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(change.beforePath, false, true, false, (Mappable)context.getServer()).getFirst();
            DeploymentPathMapping mappingAfter = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(change.afterPath, false, true, false, (Mappable)context.getServer()).getFirst();
            if (mappingBefore != null && mappingAfter != null) {
                WebServerConfig.RemotePath targetBefore = mappingBefore.mapToDeployPath(change.beforePath, (Mappable)context.getServer());
                WebServerConfig.RemotePath targetAfter = mappingAfter.mapToDeployPath(change.afterPath, (Mappable)context.getServer());
                if (change.isDirectory) {
                    if (!(change.beforePath.equals(change.afterPath) || UploadCheckinHandlerFactory.isEmptyDirectory(change.afterPath) && !context.getConfig().isCreateEmptyDirectories())) {
                        result.add(new TransferOperation.RemoteMoveOrUpload(change.afterPath, targetBefore, targetAfter, true));
                    }
                } else {
                    FileObject sourceAfter = DeploymentPathUtils.getLocalFile(change.afterPath);
                    if (targetBefore.equals(targetAfter)) {
                        result.add(new TransferOperation.Copy(sourceAfter, targetAfter));
                    } else {
                        result.add(new TransferOperation.RemoteMoveOrUpload(change.afterPath, targetBefore, targetAfter, false));
                    }
                }
            } else if (mappingBefore != null) {
                UploadCheckinHandlerFactory.processCreate(context, result, change.afterPath, true);
            } else if (mappingAfter != null) {
                UploadCheckinHandlerFactory.processDelete(context, result, change.beforePath, change.isDirectory);
            }
        }
    }

    private static void processCreate(ExecutionContext context, List<TransferOperation> result, String path, boolean isDirectory) throws FileSystemException {
        if (isDirectory) {
            DeploymentPathMapping mapping;
            if (context.getConfig().isCreateEmptyDirectories() && (mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(path, false, true, false, (Mappable)context.getServer()).getFirst()) != null && UploadCheckinHandlerFactory.isEmptyDirectory(path)) {
                WebServerConfig.RemotePath targetPath = mapping.mapToDeployPath(path, (Mappable)context.getServer());
                result.add(new TransferOperation.CreateFolder(context.findRemoteFile(targetPath, true)));
            }
        } else {
            DeploymentPathMapping mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(path, false, true, false, (Mappable)context.getServer()).getFirst();
            if (mapping != null) {
                FileObject source = DeploymentPathUtils.getLocalFile(path);
                FileObject target = context.findRemoteFile(mapping.mapToDeployPath(path, (Mappable)context.getServer()), true);
                result.add(new TransferOperation.Copy(source, target));
            }
        }
    }

    private static void processDelete(ExecutionContext context, List<TransferOperation> result, String path, boolean isDirectory) throws FileSystemException {
        DeploymentPathMapping mapping = (DeploymentPathMapping)context.getConfig().getNearestMappingForLocal(path, false, true, false, (Mappable)context.getServer()).getFirst();
        if (mapping != null) {
            FileObject target = context.findRemoteFile(mapping.mapToDeployPath(path, (Mappable)context.getServer()), true);
            result.add(new TransferOperation.Delete(target, isDirectory, true));
        }
    }

    private static boolean isEmptyDirectory(String path) {
        return new File(path).list().length == 0;
    }

    private static class ChangeInfo
    implements Comparable<ChangeInfo> {
        @Nullable
        public String beforePath;
        @Nullable
        public String afterPath;
        public final boolean isDirectory;

        private ChangeInfo(Change change) {
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            this.beforePath = before != null ? before.getFile().getPresentableUrl() : null;
            this.afterPath = after != null ? after.getFile().getPresentableUrl() : null;
            this.isDirectory = before != null ? before.getFile().isDirectory() : after.getFile().isDirectory();
        }

        @Override
        public int compareTo(@NotNull ChangeInfo o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/plugins/webDeployment/UploadCheckinHandlerFactory$ChangeInfo", "compareTo"));
            }
            return StringUtil.compare((String)this.beforePath, (String)o.beforePath, (boolean)SystemInfo.isFileSystemCaseSensitive);
        }
    }
}

