/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.webDeployment.RemoteHostSelectInTarget;
import com.jetbrains.plugins.webDeployment.WDBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectInRemoteHostAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)SelectInRemoteHostAction.class.getName());

    public void update(AnActionEvent e) {
        Pair<Boolean, String> status = SelectInRemoteHostAction.getStatus(e.getDataContext());
        e.getPresentation().setText((String)status.second);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(((Boolean)status.first).booleanValue());
        } else {
            e.getPresentation().setEnabled(((Boolean)status.first).booleanValue());
        }
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/actions/SelectInRemoteHostAction", "beforeActionPerformedUpdate"));
        }
        Project project = e.getProject();
        if (project != null) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        }
        super.beforeActionPerformedUpdate(e);
    }

    private static Pair<Boolean, String> getStatus(DataContext dataContext) {
        SelectInContext selectInContext = SelectInRemoteHostAction.createSelectInContext(dataContext);
        if (selectInContext == null) {
            return Pair.create((Object)false, (Object)WDBundle.message("select.in.remote.host", new Object[0]));
        }
        RemoteHostSelectInTarget target = SelectInRemoteHostAction.findTarget(dataContext);
        return Pair.create((Object)target.canSelect(selectInContext), (Object)WDBundle.message("select.in.remote.host", new Object[0]));
    }

    public void actionPerformed(AnActionEvent e) {
        SelectInRemoteHostAction.findTarget(e.getDataContext()).selectIn(SelectInRemoteHostAction.createSelectInContext(e.getDataContext()), true);
    }

    @Nullable
    private static SelectInContext createSelectInContext(DataContext dataContext) {
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        final VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        return new SelectInContext(){

            @NotNull
            public Project getProject() {
                Project project2 = project;
                if (project2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/SelectInRemoteHostAction$1", "getProject"));
                }
                return project2;
            }

            @NotNull
            public VirtualFile getVirtualFile() {
                VirtualFile virtualFile = file;
                if (virtualFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/SelectInRemoteHostAction$1", "getVirtualFile"));
                }
                return virtualFile;
            }

            public Object getSelectorInFile() {
                return null;
            }

            public FileEditorProvider getFileEditorProvider() {
                return null;
            }
        };
    }

    @NotNull
    private static RemoteHostSelectInTarget findTarget(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        RemoteHostSelectInTarget result = (RemoteHostSelectInTarget)ContainerUtil.findInstance((Object[])Extensions.getExtensions((ExtensionPointName)SelectInTarget.EP_NAME, (AreaInstance)project), RemoteHostSelectInTarget.class);
        LOG.assertTrue(result != null);
        RemoteHostSelectInTarget remoteHostSelectInTarget = result;
        if (remoteHostSelectInTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/SelectInRemoteHostAction", "findTarget"));
        }
        return remoteHostSelectInTarget;
    }
}

