/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.autoupload;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MuteFilter {
    private static final Logger LOG_OF_MUTING = Logger.getInstance((String)"autoupload.mute");

    public abstract boolean isMuted(@NotNull VirtualFile var1);

    public abstract boolean isMuted(@NotNull VirtualFile var1, @NotNull String var2);

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    @NotNull
    public static MuteFilter create(@NotNull Change[] changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter", "create"));
        }
        MyChangesMuteFilter filter = new MyChangesMuteFilter(changes);
        if (LOG_OF_MUTING.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Created new ").append(filter).append(" for changes:\n");
            for (Change change : changes) {
                stringBuilder.append("Change:\n").append(MyChangesMuteFilter.getRevisionPath(change.getBeforeRevision())).append("\n").append(MyChangesMuteFilter.getRevisionPath(change.getAfterRevision())).append("\n");
            }
            LOG_OF_MUTING.debug(stringBuilder.toString());
        }
        MuteFilter muteFilter = MuteFilter.wrap(filter);
        if (muteFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter", "create"));
        }
        return muteFilter;
    }

    @NotNull
    public static MuteFilter create(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter", "create"));
        }
        MyPathMuteFilter filter = new MyPathMuteFilter(path);
        if (LOG_OF_MUTING.isDebugEnabled()) {
            LOG_OF_MUTING.debug("Created new " + filter + " for path \"" + path + "\"");
        }
        MuteFilter muteFilter = MuteFilter.wrap(filter);
        if (muteFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter", "create"));
        }
        return muteFilter;
    }

    public static MuteFilter create(Collection<VirtualFile> roots) {
        MyFilesMuteFilter filter = new MyFilesMuteFilter(roots);
        if (LOG_OF_MUTING.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Created new ").append(filter).append(" for changes:\n");
            for (VirtualFile root : roots) {
                stringBuilder.append(root.getPath()).append("\n");
            }
            LOG_OF_MUTING.debug(stringBuilder.toString());
        }
        return MuteFilter.wrap(filter);
    }

    private static MuteFilter wrap(MuteFilter filter) {
        return LOG_OF_MUTING.isDebugEnabled() ? new LoggingMuteFilter(filter) : filter;
    }

    private static boolean isAncestor(String ancestorPath, String path) {
        ancestorPath = FileUtil.toSystemIndependentName((String)ancestorPath);
        path = FileUtil.toSystemIndependentName((String)path);
        return VfsUtilCore.isEqualOrAncestor((String)ancestorPath, (String)path);
    }

    private static class LoggingMuteFilter
    extends MuteFilter {
        private final MuteFilter myFilter;

        private LoggingMuteFilter(MuteFilter filter) {
            this.myFilter = filter;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$LoggingMuteFilter", "isMuted"));
            }
            boolean muted = this.myFilter.isMuted(file);
            LOG_OF_MUTING.debug(this.myFilter + " for \"" + file.getPath() + "\" is " + (muted ? "" : "not ") + muted);
            return muted;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$LoggingMuteFilter", "isMuted"));
            }
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$LoggingMuteFilter", "isMuted"));
            }
            boolean muted = this.myFilter.isMuted(parent, fileName);
            LOG_OF_MUTING.debug(this.myFilter + " for \"" + parent.getPath() + "\" and \"" + fileName + "\" is " + (muted ? "" : "not ") + muted);
            return muted;
        }
    }

    private static class MyFilesMuteFilter
    extends MuteFilter {
        private final Collection<VirtualFile> myRoots;

        public MyFilesMuteFilter(Collection<VirtualFile> roots) {
            this.myRoots = roots;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyFilesMuteFilter", "isMuted"));
            }
            for (VirtualFile root : this.myRoots) {
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyFilesMuteFilter", "isMuted"));
            }
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyFilesMuteFilter", "isMuted"));
            }
            for (VirtualFile root : this.myRoots) {
                if (fileName.equals(root.getName()) && parent.equals(root.getParent())) {
                    return true;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)parent, (boolean)false)) continue;
                return true;
            }
            return false;
        }
    }

    private static class MyPathMuteFilter
    extends MuteFilter {
        private final String myPath;

        public MyPathMuteFilter(String path) {
            if (SystemInfo.isWindows && path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
                path = path.substring(2);
            }
            this.myPath = path;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyPathMuteFilter", "isMuted"));
            }
            return MuteFilter.isAncestor(this.myPath, file.getPath());
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyPathMuteFilter", "isMuted"));
            }
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyPathMuteFilter", "isMuted"));
            }
            String path = parent.getPath() + "/" + fileName;
            return MuteFilter.isAncestor(this.myPath, path);
        }
    }

    private static class MyChangesMuteFilter
    extends MuteFilter {
        private final Change[] myChanges;

        public MyChangesMuteFilter(@NotNull Change[] changes) {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyChangesMuteFilter", "<init>"));
            }
            this.myChanges = changes;
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyChangesMuteFilter", "isMuted"));
            }
            return this.isMuted(file.getPath());
        }

        @Override
        public boolean isMuted(@NotNull VirtualFile parent, @NotNull String fileName) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyChangesMuteFilter", "isMuted"));
            }
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/plugins/webDeployment/autoupload/MuteFilter$MyChangesMuteFilter", "isMuted"));
            }
            return this.isMuted(parent.getPath() + "/" + fileName);
        }

        private boolean isMuted(String path) {
            for (Change change : this.myChanges) {
                if (MyChangesMuteFilter.isMuted(path, change.getBeforeRevision())) {
                    return true;
                }
                if (!MyChangesMuteFilter.isMuted(path, change.getAfterRevision())) continue;
                return true;
            }
            return false;
        }

        private static boolean isMuted(String path, @Nullable ContentRevision revision) {
            String revisionPath = MyChangesMuteFilter.getRevisionPath(revision);
            return revisionPath != null && MuteFilter.isAncestor(revisionPath, path);
        }

        @Nullable
        static String getRevisionPath(@Nullable ContentRevision revision) {
            if (revision == null) {
                return null;
            }
            FilePath filePath = revision.getFile();
            return filePath.getPath();
        }
    }
}

