/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SftpUserInfo
implements UserInfo,
UIKeyboardInteractive {
    private static final Logger LOG = Logger.getInstance((String)SftpUserInfo.class.getName());
    @NotNull
    private final Deployable myDeployable;
    @NotNull
    private final FileTransferConfig myConfig;
    @NotNull
    private final ConnectionOwner myConnectionOwner;
    @NotNull
    private final String myTitle;
    @Nullable
    private final ProgressIndicator myProgressIndicator;

    public SftpUserInfo(@NotNull FileTransferConfig config, @NotNull ConnectionOwner connectionOwner, @NotNull String title, @NotNull Deployable deployable, @Nullable ProgressIndicator pi) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/config/SftpUserInfo", "<init>"));
        }
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/config/SftpUserInfo", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/config/SftpUserInfo", "<init>"));
        }
        if (deployable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployable", "com/jetbrains/plugins/webDeployment/config/SftpUserInfo", "<init>"));
        }
        this.myConfig = config;
        this.myConnectionOwner = connectionOwner;
        this.myTitle = title;
        this.myDeployable = deployable;
        this.myProgressIndicator = pi;
    }

    public String getPassphrase() {
        Credentials credentials = this.myDeployable.getCredentials();
        return credentials == null ? null : credentials.getPasswordAsString();
    }

    public String getPassword() {
        Credentials credentials = this.myDeployable.getCredentials();
        return StringUtil.notNullize((String)(credentials == null ? null : credentials.getPasswordAsString()));
    }

    public boolean promptPassword(String message) {
        return true;
    }

    public boolean promptPassphrase(String message) {
        return true;
    }

    public boolean promptYesNo(String message) {
        return this.myConnectionOwner.promptYesNo(message, this.myTitle, this.myProgressIndicator);
    }

    public void showMessage(String message) {
        if (this.myConfig.getAdvancedOptions().isMuteSftpMessages()) {
            return;
        }
        DialogWrapper.DoNotAskOption option = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                SftpUserInfo.this.myConfig.getAdvancedOptions().setMuteSftpMessages(!value);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = WDBundle.message("do.not.show.messages.from.this.server.can.be.changed.in.server.s.advanced.settings", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/SftpUserInfo$1", "getDoNotShowMessage"));
                }
                return string;
            }
        };
        this.myConnectionOwner.showMessage(message, this.myTitle, this.myDeployable, this.myProgressIndicator, option);
    }

    @Nullable
    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        if (prompt.length == 1 && !echo[0]) {
            if (SftpUserInfo.isPasswordPrompted(prompt[0])) {
                String[] stringArray;
                String password;
                Credentials credentials = this.myDeployable.getCredentials();
                String string = password = credentials != null ? credentials.getPasswordAsString() : null;
                if (password != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = password;
                } else {
                    stringArray = null;
                }
                return stringArray;
            }
            if (Registry.is((String)"ide.ssh.one.time.password")) {
                String[] stringArray;
                String password = this.myConnectionOwner.promptPassword(prompt[0], this.myTitle, this.myProgressIndicator);
                if (password != null) {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = password;
                } else {
                    stringArray = null;
                }
                return stringArray;
            }
        }
        StringBuilder msg = new StringBuilder("Unsupported keyboard interactive request: ");
        msg.append("destination=\"").append(destination).append("\", ");
        msg.append("name=\"").append(name).append("\", ");
        msg.append("instruction=\"").append(instruction).append("\", ");
        if (prompt.length > 0) {
            msg.append("prompt=[\"").append(StringUtil.join((String[])prompt, (String)"\",\"")).append("\"]");
        } else {
            msg.append("prompt=[]");
        }
        LOG.warn(msg.toString());
        return null;
    }

    @Contract(pure=true)
    public static boolean isPasswordPrompted(@NotNull String promptMessage) {
        if (promptMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promptMessage", "com/jetbrains/plugins/webDeployment/config/SftpUserInfo", "isPasswordPrompted"));
        }
        return StringUtil.containsIgnoreCase((String)promptMessage, (String)"password") || StringUtil.containsIgnoreCase((String)promptMessage, (String)"passwort");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SftpUserInfo that = (SftpUserInfo)o;
        if (!this.myConfig.equals(that.myConfig)) {
            return false;
        }
        return this.myDeployable.equals(that.myDeployable);
    }

    public int hashCode() {
        int result = this.myDeployable.hashCode();
        result = 31 * result + this.myConfig.hashCode();
        return result;
    }
}

