/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.sftp.SftpAdvancedOptions;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebServersConfigManager {
    public abstract void setServers(List<WebServerConfig> var1);

    public abstract List<WebServerConfig> getServers(boolean var1);

    public abstract void addServer(WebServerConfig var1);

    @Nullable
    public WebServerConfig findServer(String serverId) {
        return this.findServer(serverId, false);
    }

    @Nullable
    public WebServerConfig findServer(String serverId, boolean remoteOnly) {
        if (StringUtil.isEmpty((String)serverId)) {
            return null;
        }
        for (WebServerConfig server : this.getServers(remoteOnly)) {
            if (!serverId.equals(server.getId())) continue;
            return server;
        }
        return null;
    }

    @NotNull
    public abstract SftpAdvancedOptions getSftpAdvancedOptions();

    public abstract void setSftpAdvancedOptions(@NotNull SftpAdvancedOptions var1);

    @NotNull
    public static WebServersConfigManager getInstance(@Nullable Project project) {
        WebServersConfigManager webServersConfigManager = (WebServersConfigManager)ServiceManager.getService((Project)(project == null ? ProjectManager.getInstance().getDefaultProject() : project), WebServersConfigManager.class);
        if (webServersConfigManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManager", "getInstance"));
        }
        return webServersConfigManager;
    }

    public abstract WebServerConfig moveServer(WebServerConfig var1);

    public boolean setUniqueName(@NotNull WebServerConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManager", "setUniqueName"));
        }
        HashSet serverNames = new HashSet();
        for (WebServerConfig server : this.getServers(false)) {
            serverNames.add(server.getName());
        }
        boolean changed = false;
        if (serverNames.contains(config.getName())) {
            String serverNameBase = config.getName();
            int i = 1;
            String serverName = serverNameBase;
            while (serverNames.contains(serverName)) {
                serverName = serverNameBase + " (" + i + ")";
                ++i;
            }
            changed = true;
            config.setName(serverName);
        }
        return changed;
    }
}

