/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config.sockets;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.config.sockets.DeploymentSocketUtils;
import com.jetbrains.plugins.webDeployment.config.sockets.ItemHolder;
import com.jetbrains.plugins.webDeployment.config.sockets.SocketWrapper;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import org.jetbrains.annotations.Nullable;

class MyFtpSocketFactoryBase
extends SocketFactory {
    private static final Logger LOG = Logger.getInstance((String)MyFtpSocketFactoryBase.class.getName());
    private final SocketFactory myDelegate;
    @Nullable
    private final ItemHolder<Socket> mySockets;

    MyFtpSocketFactoryBase(@Nullable EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> disconnectTrigger) {
        ItemHolder<Socket> sockets;
        SocketFactory delegate = SocketFactory.getDefault();
        if (disconnectTrigger != null) {
            sockets = ItemHolder.createDefaultSocketHolder();
            disconnectTrigger.addListener(sockets);
        } else {
            sockets = null;
        }
        this.myDelegate = delegate;
        this.mySockets = sockets;
    }

    MyFtpSocketFactoryBase(SocketFactory delegate, @Nullable ItemHolder<Socket> sockets) {
        this.myDelegate = delegate;
        this.mySockets = sockets;
    }

    private void registerSocket(Socket socket) throws IOException {
        if (this.mySockets != null) {
            this.mySockets.add(socket);
        }
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.createPatchedSocketIfNeeded(s, null, i, null, null);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress localAddress, int i1) throws IOException {
        return this.createPatchedSocketIfNeeded(s, null, i, localAddress, i1);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this.createPatchedSocketIfNeeded(null, inetAddress, i, null, null);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress localAddress, int i1) throws IOException {
        return this.createPatchedSocketIfNeeded(null, inetAddress, i, localAddress, i1);
    }

    private Socket createPatchedSocketIfNeeded(@Nullable String host, @Nullable InetAddress address, int port, @Nullable InetAddress localAddr, @Nullable Integer localPort) throws IOException {
        InetAddress inetAddress = address == null ? InetAddress.getByName(host) : address;
        InetAddress properAddress = DeploymentSocketUtils.getProperAddressIfNeeded(inetAddress);
        Socket socket = properAddress != null ? this.createDelegateSocket(null, properAddress, port, localAddr, localPort, true) : this.createDelegateSocket(host, address, port, localAddr, localPort, false);
        this.registerSocket(socket);
        return socket;
    }

    private Socket createDelegateSocket(@Nullable String host, @Nullable InetAddress address, int port, @Nullable InetAddress localAddr, @Nullable Integer localPort, boolean patched) throws IOException {
        LOG.debug((patched ? "Patched" : "Default") + " ftp socket for " + (address == null ? host : address) + " " + port + (localPort == null ? "" : " " + localAddr + " " + localPort));
        if (localPort == null) {
            if (address == null) {
                return this.myDelegate.createSocket(host, port);
            }
            return this.myDelegate.createSocket(address, port);
        }
        if (address == null) {
            return this.myDelegate.createSocket(host, port, localAddr, (int)localPort);
        }
        return this.myDelegate.createSocket(address, port, localAddr, (int)localPort);
    }

    @Override
    public Socket createSocket() throws IOException {
        SocketWrapper socket = new SocketWrapper(this.myDelegate.createSocket());
        this.registerSocket(socket);
        return socket;
    }

    public boolean equals(Object obj) {
        return obj instanceof MyFtpSocketFactoryBase;
    }

    public int hashCode() {
        return 0;
    }
}

