/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;

class FileSystemDebugComparator {
    FileSystemDebugComparator() {
    }

    static String getDivergeDescription(FileSystem fresh, FileSystem existed) {
        FileName existedRootName;
        StringBuilder sb = new StringBuilder();
        FileName freshRootName = fresh.getRootName();
        int compareTo = freshRootName.compareTo((Object)(existedRootName = existed.getRootName()));
        if (compareTo != 0) {
            sb.append("Root names are not equal\n");
            sb.append("Existing: ").append(existedRootName).append("; ").append(existedRootName.getClass()).append("\n");
            sb.append("New: ").append(freshRootName).append("; ").append(freshRootName.getClass()).append("\n");
            return sb.toString();
        }
        sb.append("Root names are equal\n");
        FileSystemOptions freshOptions = fresh.getFileSystemOptions();
        FileSystemOptions existedOptions = existed.getFileSystemOptions();
        if (freshOptions == null && existedOptions == null) {
            sb.append("All options are null\n");
        } else if (freshOptions != null && existedOptions != null) {
            int compareOptionsTo = freshOptions.compareTo(existedOptions);
            if (compareOptionsTo == 0) {
                sb.append("File options are equal\n");
            } else {
                sb.append("File options are not equal\n");
                FileSystemDebugComparator.investigateOptions(existedOptions, sb, freshOptions);
            }
        } else {
            sb.append("One option is null, other not\n");
        }
        sb.append("\n Existed:\n").append(existedOptions).append("\n\n");
        sb.append("\n Fresh:\n").append(freshOptions);
        return sb.toString();
    }

    private static void investigateOptions(FileSystemOptions existedOptions, StringBuilder sb, FileSystemOptions freshOptions) {
        try {
            Field optionsField = FileSystemOptions.class.getDeclaredField("options");
            optionsField.setAccessible(true);
            Map freshMap = (Map)optionsField.get(freshOptions);
            Map existedMap = (Map)optionsField.get(existedOptions);
            optionsField.setAccessible(false);
            if (freshMap.size() != existedMap.size()) {
                sb.append("Different sizes: ").append(freshMap.size()).append(", ").append(existedMap.size()).append("\n");
            } else {
                FileSystemDebugComparator.investigateOptionsContent(freshMap, existedMap, sb);
            }
        }
        catch (NoSuchFieldException e) {
            sb.append(e);
        }
        catch (IllegalAccessException e) {
            sb.append(e);
        }
    }

    private static void investigateOptionsContent(Map<Comparable, Object> freshMap, Map<Comparable, Object> existedMap, StringBuilder sb) {
        SortedMap<Object, Object> sortedFreshOptions = freshMap instanceof SortedMap ? (SortedMap<Object, Object>)freshMap : new TreeMap<Comparable, Object>(freshMap);
        SortedMap<Object, Object> sortedExistedOptions = existedMap instanceof SortedMap ? (SortedMap<Object, Object>)existedMap : new TreeMap<Comparable, Object>(existedMap);
        Iterator freshKeysIter = sortedFreshOptions.keySet().iterator();
        Iterator existedKeysIter = sortedExistedOptions.keySet().iterator();
        while (freshKeysIter.hasNext()) {
            Comparable nextExisted;
            Comparable nextFresh = (Comparable)freshKeysIter.next();
            int comp = nextFresh.compareTo(nextExisted = (Comparable)existedKeysIter.next());
            if (comp == 0) continue;
            sb.append("Unequal keys:").append("\n").append(nextFresh).append("\n").append(nextExisted);
            return;
        }
        sb.append("All keys are equal\n");
        Object[] array = new Object[freshMap.size()];
        Object[] freshValues = freshMap.values().toArray(array);
        int hashFresh = Arrays.deepHashCode(freshValues);
        Object[] existedValues = existedMap.values().toArray(array);
        int hashExisted = Arrays.deepHashCode(existedValues);
        if (hashFresh == hashExisted) {
            sb.append("Deep hashes are equal\n");
            return;
        }
        sb.append("Deep hashes are not equal\n");
        for (int i = 0; i < freshValues.length; ++i) {
            int existedHash;
            Object freshValue = freshValues[i];
            Object existedValue = existedValues[i];
            int freshHash = freshValue.hashCode();
            if (freshHash != (existedHash = existedValue.hashCode())) {
                sb.append("Different hashes for i=").append(i).append("\n");
                sb.append("Fresh ").append(freshValue).append("\n");
                sb.append("Existed ").append(existedValue).append("\n");
                return;
            }
            sb.append("Equal hasheds for ").append(freshValue).append("\n");
        }
    }
}

