/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;

public class PatchedFtpFileSystem
extends FtpFileSystem {
    private static final Logger LOG = Logger.getInstance((String)PatchedFtpFileSystem.class.getName());
    private final AtomicReference<FtpClient> idleClient = new AtomicReference();
    private final Disposable myDisposable = new Disposable(){

        public void dispose() {
        }
    };
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);

    public PatchedFtpFileSystem(GenericFileName rootName, FtpClient ftpClient, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.idleClient.set(ftpClient);
        final Integer keepAliveTimeout = FtpFileSystemConfigBuilder.getInstance().getKeepAliveTimeout(fileSystemOptions);
        final JBFtpKeepAliveCommand keepAliveCommand = FtpFileSystemConfigBuilder.getInstance().getKeepAliveCommand(fileSystemOptions);
        if (keepAliveTimeout != null && keepAliveTimeout > 0) {
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    FtpClient client = PatchedFtpFileSystem.this.idleClient.getAndSet(null);
                    if (client == null) {
                        this.renewAlarm();
                        return;
                    }
                    try {
                        keepAliveCommand.invoke(client);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to send keep-alive message.", (Throwable)e);
                        PatchedFtpFileSystem.closeConnection(client);
                        this.run();
                        return;
                    }
                    FtpClient oldClient = PatchedFtpFileSystem.this.idleClient.getAndSet(client);
                    if (oldClient != null) {
                        PatchedFtpFileSystem.closeConnection(oldClient);
                    }
                    this.renewAlarm();
                }

                private void renewAlarm() {
                    if (!PatchedFtpFileSystem.this.myAlarm.isDisposed()) {
                        PatchedFtpFileSystem.this.myAlarm.addRequest((Runnable)this, keepAliveTimeout.intValue());
                    }
                }
            }, keepAliveTimeout.intValue());
        }
    }

    protected void doCloseCommunicationLink() {
        FtpClient idle = this.idleClient.getAndSet(null);
        if (idle != null) {
            PatchedFtpFileSystem.closeConnection(idle);
        }
    }

    private static void closeConnection(FtpClient client) {
        try {
            if (client.isConnected()) {
                client.disconnect();
            }
        }
        catch (IOException e) {
            LOG.warn("Could not close connection to FTP server.", (Throwable)e);
        }
    }

    public FtpClient getClient() throws FileSystemException {
        FtpClient client = this.idleClient.getAndSet(null);
        if (client == null || !client.isConnected()) {
            client = this.createWrapper();
        }
        return client;
    }

    public void putClient(FtpClient client) {
        if (!this.idleClient.compareAndSet(null, client)) {
            PatchedFtpFileSystem.closeConnection(client);
        }
    }

    public void close() {
        super.close();
        this.myAlarm.cancelAllRequests();
        Disposer.dispose((Disposable)this.myDisposable);
    }
}

