/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpStreamProxy;
import org.apache.commons.vfs2.util.Os;
import org.apache.commons.vfs2.util.OsFamily;

public final class SftpClientFactoryCopy {
    private static final String SSH_DIR_NAME = ".ssh";
    private static final Log LOG = LogFactory.getLog((String)"com.jetbrains.plugins.webDeployment.sftp");

    private SftpClientFactoryCopy() {
    }

    public static Session createConnection(String hostname, int port, char[] username, char[] password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        Session session;
        JSch jsch = new JSch();
        File sshDir = null;
        SftpFileSystemConfigBuilder builder = SftpFileSystemConfigBuilder.getInstance();
        File knownHostsFile = builder.getKnownHosts(fileSystemOptions);
        IdentityInfo[] identities = builder.getIdentityInfo(fileSystemOptions);
        IdentityRepositoryFactory repositoryFactory = builder.getIdentityRepositoryFactory(fileSystemOptions);
        sshDir = SftpClientFactoryCopy.findSshDir();
        SftpClientFactoryCopy.setKnownHosts(jsch, sshDir, knownHostsFile);
        if (repositoryFactory != null) {
            jsch.setIdentityRepository(repositoryFactory.create(jsch));
        }
        SftpClientFactoryCopy.addIdentities(jsch, sshDir, identities);
        try {
            Integer keepAliveCountMax;
            Integer keepAliveTimeout;
            SocketFactory socketFactory;
            String proxyHost;
            String compression;
            String preferredAuthentications;
            UserInfo userInfo;
            Integer timeout;
            session = jsch.getSession(new String(username), hostname, port);
            if (password != null) {
                session.setPassword(new String(password));
            }
            if ((timeout = builder.getTimeout(fileSystemOptions)) != null) {
                session.setTimeout(timeout.intValue());
            }
            if ((userInfo = builder.getUserInfo(fileSystemOptions)) != null) {
                session.setUserInfo(userInfo);
            }
            Properties config = new Properties();
            String strictHostKeyChecking = builder.getStrictHostKeyChecking(fileSystemOptions);
            if (strictHostKeyChecking != null) {
                config.setProperty("StrictHostKeyChecking", strictHostKeyChecking);
            }
            if ((preferredAuthentications = builder.getPreferredAuthentications(fileSystemOptions)) != null) {
                config.setProperty("PreferredAuthentications", preferredAuthentications);
            }
            if ((compression = builder.getCompression(fileSystemOptions)) != null) {
                config.setProperty("compression.s2c", compression);
                config.setProperty("compression.c2s", compression);
            }
            if ((proxyHost = builder.getProxyHost(fileSystemOptions)) != null) {
                int proxyPort = builder.getProxyPort(fileSystemOptions);
                SftpFileSystemConfigBuilder.ProxyType proxyType = builder.getProxyType(fileSystemOptions);
                ProxyHTTP proxy = null;
                if (SftpFileSystemConfigBuilder.PROXY_HTTP.equals((Object)proxyType)) {
                    proxy = SftpClientFactoryCopy.createProxyHTTP(proxyHost, proxyPort);
                } else if (SftpFileSystemConfigBuilder.PROXY_SOCKS5.equals((Object)proxyType)) {
                    proxy = SftpClientFactoryCopy.createProxySOCKS5(proxyHost, proxyPort);
                } else if (SftpFileSystemConfigBuilder.PROXY_STREAM.equals((Object)proxyType)) {
                    proxy = SftpClientFactoryCopy.createStreamProxy(proxyHost, proxyPort, fileSystemOptions, builder);
                }
                if (proxy != null) {
                    session.setProxy((Proxy)proxy);
                }
            }
            if (config.size() > 0) {
                session.setConfig(config);
            }
            if ((socketFactory = builder.getSocketFactory(fileSystemOptions)) != null) {
                session.setSocketFactory(socketFactory);
            }
            if ((keepAliveTimeout = builder.getKeepAliveTimeout(fileSystemOptions)) != null) {
                session.setServerAliveInterval(keepAliveTimeout.intValue());
            }
            if ((keepAliveCountMax = builder.getKeepAliveMaxCount(fileSystemOptions)) != null) {
                session.setServerAliveCountMax(keepAliveCountMax.intValue());
            }
            session.setDaemonThread(true);
            session.connect();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Throwable)exc, new Object[]{hostname});
        }
        return session;
    }

    public static void addIdentities(JSch jsch, File sshDir, IdentityInfo[] identities) throws FileSystemException {
        if (identities != null) {
            for (IdentityInfo info : identities) {
                SftpClientFactoryCopy.addIndentity(jsch, info);
            }
        } else {
            File privateKeyFile = new File(sshDir, "id_rsa");
            if (privateKeyFile.isFile() && privateKeyFile.canRead()) {
                SftpClientFactoryCopy.addIndentity(jsch, new IdentityInfo(privateKeyFile));
            }
        }
    }

    private static void addIndentity(JSch jsch, IdentityInfo info) throws FileSystemException {
        try {
            String privateKeyFile = info.getPrivateKey() != null ? info.getPrivateKey().getAbsolutePath() : null;
            String publicKeyFile = info.getPublicKey() != null ? info.getPublicKey().getAbsolutePath() : null;
            jsch.addIdentity(privateKeyFile, publicKeyFile, info.getPassPhrase());
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/load-private-key.error", (Object)info, (Throwable)e);
        }
    }

    public static void setKnownHosts(JSch jsch, File sshDir, File knownHostsFile) throws FileSystemException {
        try {
            if (knownHostsFile != null) {
                jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
            } else {
                knownHostsFile = new File(sshDir, "known_hosts");
                if (knownHostsFile.isFile() && knownHostsFile.canRead()) {
                    jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
                }
            }
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/known-hosts.error", (Object)knownHostsFile.getAbsolutePath(), (Throwable)e);
        }
    }

    static Proxy createStreamProxy(String proxyHost, int proxyPort, FileSystemOptions fileSystemOptions, SftpFileSystemConfigBuilder builder) {
        String proxyUser = builder.getProxyUser(fileSystemOptions);
        String proxyPassword = builder.getProxyPassword(fileSystemOptions);
        FileSystemOptions proxyOptions = builder.getProxyOptions(fileSystemOptions);
        String proxyCommand = builder.getProxyCommand(fileSystemOptions);
        SftpStreamProxy proxy = new SftpStreamProxy(proxyCommand, proxyUser, proxyHost, proxyPort, proxyPassword, proxyOptions);
        return proxy;
    }

    static ProxySOCKS5 createProxySOCKS5(String proxyHost, int proxyPort) {
        return proxyPort == 0 ? new ProxySOCKS5(proxyHost) : new ProxySOCKS5(proxyHost, proxyPort);
    }

    static ProxyHTTP createProxyHTTP(String proxyHost, int proxyPort) {
        return proxyPort == 0 ? new ProxyHTTP(proxyHost) : new ProxyHTTP(proxyHost, proxyPort);
    }

    public static File findSshDir() {
        File sshDir;
        String sshDirPath = System.getProperty("vfs.sftp.sshdir");
        if (sshDirPath != null && (sshDir = new File(sshDirPath)).exists()) {
            return sshDir;
        }
        sshDir = new File(System.getProperty("user.home"), SSH_DIR_NAME);
        if (sshDir.exists()) {
            return sshDir;
        }
        if (Os.isFamily((OsFamily)Os.OS_FAMILY_WINDOWS)) {
            String userName = System.getProperty("user.name");
            sshDir = new File("C:\\cygwin\\home\\" + userName + "\\" + SSH_DIR_NAME);
            if (sshDir.exists()) {
                return sshDir;
            }
        }
        return new File("");
    }

    static {
        JSch.setLogger((Logger)new JSchLogger());
    }

    private static class JSchLogger
    implements Logger {
        private JSchLogger() {
        }

        public boolean isEnabled(int level) {
            switch (level) {
                case 4: {
                    return LOG.isFatalEnabled();
                }
                case 3: {
                    return LOG.isErrorEnabled();
                }
                case 2: {
                    return LOG.isWarnEnabled();
                }
                case 0: {
                    return LOG.isDebugEnabled();
                }
                case 1: {
                    return LOG.isDebugEnabled();
                }
            }
            return LOG.isDebugEnabled();
        }

        public void log(int level, String msg) {
            switch (level) {
                case 4: {
                    LOG.fatal((Object)msg);
                    break;
                }
                case 3: {
                    LOG.error((Object)msg);
                    break;
                }
                case 2: {
                    LOG.warn((Object)msg);
                    break;
                }
                case 0: {
                    LOG.debug((Object)msg);
                    break;
                }
                case 1: {
                    LOG.debug((Object)msg);
                    break;
                }
                default: {
                    LOG.debug((Object)msg);
                }
            }
        }
    }
}

