/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jetbrains.plugins.webDeployment.connections.PatchedSftpFileProvider;
import com.jetbrains.plugins.webDeployment.connections.SftpFileObjectCopy;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;

public abstract class SftpFileSystemCopy
extends SftpFileSystem {
    protected static final int SLEEP_MILLIS = 100;
    protected static final int EXEC_BUFFER_SIZE = 128;
    private static final long LAST_MOD_TIME_ACCURACY = 1000L;
    protected ChannelSftp idleChannel;
    private int uid = -1;
    private int[] groupsIds;

    protected SftpFileSystemCopy(GenericFileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void putChannel(ChannelSftp channel) {
        if (this.idleChannel == null) {
            if (channel.isConnected() && !channel.isClosed()) {
                this.idleChannel = channel;
            }
        } else {
            channel.disconnect();
        }
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(PatchedSftpFileProvider.getSftpCapabilities());
    }

    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new SftpFileObjectCopy(name, this);
    }

    public double getLastModTimeAccuracy() {
        return 1000.0;
    }

    public int[] getGroupsIds() throws JSchException, IOException {
        if (this.groupsIds == null) {
            StringBuilder output = new StringBuilder();
            int code = this.executeCommand("id -G", output);
            if (code != 0) {
                throw new JSchException("Could not get the groups id of the current user (error code: " + code + ")");
            }
            String[] groups = output.toString().trim().split("\\s+");
            int[] groupsIds = new int[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                groupsIds[i] = Integer.parseInt(groups[i]);
            }
            this.groupsIds = groupsIds;
        }
        return this.groupsIds;
    }

    public int getUId() throws JSchException, IOException {
        if (this.uid < 0) {
            StringBuilder output = new StringBuilder();
            int code = this.executeCommand("id -u", output);
            if (code != 0) {
                throw new FileSystemException("Could not get the user id of the current user (error code: " + code + ")");
            }
            this.uid = Integer.parseInt(output.toString().trim());
        }
        return this.uid;
    }

    protected abstract int executeCommand(String var1, StringBuilder var2) throws JSchException, IOException;
}

