/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit.fs;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.remoteEdit.FileContentQueue;
import com.jetbrains.plugins.webDeployment.remoteEdit.RemoteEditUploadFilesTask;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class RemoteEditedFilesUploadingService {
    private static final Logger LOG = Logger.getInstance(RemoteEditedFilesUploadingService.class);
    private final Project myProject;
    private final FileContentQueue myQueue = new FileContentQueue();
    private final Object TASK_LOCK = new Object();
    private RemoteEditUploadFilesTask myTask;

    @NotNull
    public static RemoteEditedFilesUploadingService getInstance(Project project) {
        RemoteEditedFilesUploadingService remoteEditedFilesUploadingService = (RemoteEditedFilesUploadingService)ServiceManager.getService((Project)project, RemoteEditedFilesUploadingService.class);
        if (remoteEditedFilesUploadingService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteEditedFilesUploadingService", "getInstance"));
        }
        return remoteEditedFilesUploadingService;
    }

    public RemoteEditedFilesUploadingService(Project project) {
        this.myProject = project;
    }

    public void queueUpload(RemoteVirtualFile file) {
        try {
            byte[] content = file.contentsToByteArray();
            this.queueUpload(file, content);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpload(@NotNull RemoteVirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteEditedFilesUploadingService", "queueUpload"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteEditedFilesUploadingService", "queueUpload"));
        }
        this.myQueue.pushFile(file, content);
        Object object = this.TASK_LOCK;
        synchronized (object) {
            if (!this.myQueue.isEmpty() && (this.myTask == null || this.myTask.isFinished())) {
                this.myTask = new RemoteEditUploadFilesTask(this.myProject, ConnectionOwnerFactory.createConnectionOwner(this.myProject), WDBundle.message("remote.edit.uploading.edited.content.of.remote.files", new Object[0]), this.myQueue);
                this.myTask.queue();
            }
        }
    }
}

