/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.transport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jetbrains.plugins.webDeployment.transport.ChannelFactory;
import com.jetbrains.plugins.webDeployment.transport.ExecChannel;
import com.jetbrains.plugins.webDeployment.transport.ExecChannelConfig;
import com.jetbrains.plugins.webDeployment.transport.SessionConfig;
import com.jetbrains.plugins.webDeployment.transport.SftpChannel;
import com.jetbrains.plugins.webDeployment.transport.SftpChannelConfig;
import com.jetbrains.plugins.webDeployment.transport.ShellChannel;
import com.jetbrains.plugins.webDeployment.transport.ShellChannelConfig;
import com.jetbrains.plugins.webDeployment.transport.SshChannel;
import com.jetbrains.plugins.webDeployment.transport.SshConnection;
import com.jetbrains.plugins.webDeployment.transport.SshConnectionUtil;
import com.jetbrains.plugins.webDeployment.transport.SshSession;
import com.jetbrains.plugins.webDeployment.transport.SshSessionKey;
import com.jetbrains.plugins.webDeployment.transport.SshTransportException;
import com.jetbrains.plugins.webDeployment.transport.channels.ExecChannelImpl;
import com.jetbrains.plugins.webDeployment.transport.channels.SftpChannelImpl;
import com.jetbrains.plugins.webDeployment.transport.channels.ShellChannelImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J-\u0010\u0011\u001a\u0002H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0003\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0019H\u0007J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u001cH\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/plugins/webDeployment/transport/SshConnectionService;", "Lcom/intellij/openapi/Disposable;", "()V", "pool", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/plugins/webDeployment/transport/SshSessionKey;", "Lcom/jetbrains/plugins/webDeployment/transport/SshConnection;", "connect", "Lcom/jetbrains/plugins/webDeployment/transport/SshSession;", "sessionConfig", "Lcom/jetbrains/plugins/webDeployment/transport/SessionConfig;", "dispose", "", "exec", "Lcom/jetbrains/plugins/webDeployment/transport/ExecChannel;", "channelConfig", "Lcom/jetbrains/plugins/webDeployment/transport/ExecChannelConfig;", "openChannel", "R", "Lcom/jetbrains/plugins/webDeployment/transport/SshChannel;", "channelCreator", "Lcom/jetbrains/plugins/webDeployment/transport/ChannelFactory;", "(Lcom/jetbrains/plugins/webDeployment/transport/SessionConfig;Lcom/jetbrains/plugins/webDeployment/transport/ChannelFactory;)Lcom/jetbrains/plugins/webDeployment/transport/SshChannel;", "sftp", "Lcom/jetbrains/plugins/webDeployment/transport/SftpChannel;", "Lcom/jetbrains/plugins/webDeployment/transport/SftpChannelConfig;", "shell", "Lcom/jetbrains/plugins/webDeployment/transport/ShellChannel;", "Lcom/jetbrains/plugins/webDeployment/transport/ShellChannelConfig;", "Companion", "webDeployment"})
public final class SshConnectionService
implements Disposable {
    private final ConcurrentHashMap<SshSessionKey, SshConnection> pool = new ConcurrentHashMap();
    private static final Logger LOG;
    public static final Companion Companion;

    public void dispose() {
        SshConnectionService.Companion.getLOG().debug("Disconnecting SSH connections on " + SshConnectionService.class + " dispose");
        Map map = this.pool;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            SshSessionKey key = (SshSessionKey)entry2.getKey();
            entry2 = entry;
            SshConnection value = (SshConnection)entry2.getValue();
            value.disconnect();
        }
        this.pool.clear();
    }

    @NotNull
    public final SshSession connect(@NotNull SessionConfig sessionConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        SshSessionKey sessionKey = new SshSessionKey(sessionConfig);
        SshConnection sshConnection2 = this.pool.computeIfAbsent(sessionKey, new Function<SshSessionKey, SshConnection>(sessionKey){
            final /* synthetic */ SshSessionKey $sessionKey;

            @NotNull
            public final SshConnection apply(SshSessionKey it) {
                return new SshConnection(this.$sessionKey.getUsername(), this.$sessionKey.getHost(), this.$sessionKey.getPort());
            }
            {
                this.$sessionKey = sshSessionKey;
            }
        });
        return sshConnection2.getSshSession(sessionConfig);
    }

    @NotNull
    public final ExecChannel exec(@NotNull SessionConfig sessionConfig, @NotNull ExecChannelConfig channelConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkParameterIsNotNull((Object)channelConfig, (String)"channelConfig");
        SshSessionKey sessionKey = new SshSessionKey(sessionConfig);
        SshConnection sshConnection2 = this.pool.computeIfAbsent(sessionKey, new Function<SshSessionKey, SshConnection>(sessionKey){
            final /* synthetic */ SshSessionKey $sessionKey;

            @NotNull
            public final SshConnection apply(SshSessionKey it) {
                return new SshConnection(this.$sessionKey.getUsername(), this.$sessionKey.getHost(), this.$sessionKey.getPort());
            }
            {
                this.$sessionKey = sshSessionKey;
            }
        });
        return (ExecChannel)sshConnection2.openChannel(sessionConfig, (ChannelFactory)new ChannelFactory<ExecChannel>(channelConfig){
            final /* synthetic */ ExecChannelConfig $channelConfig;

            @NotNull
            public ExecChannel create(@NotNull SshSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                com.jetbrains.plugins.webDeployment.transport.SshConnectionService$Companion.access$getLOG$p(SshConnectionService.Companion).info("Executing SSH command: " + this.$channelConfig.getCommand() + " within " + session);
                Channel channel = session.getRawSession().openChannel(SshConnectionUtil.INSTANCE.getEXEC_CHANNEL_TYPE());
                if (channel == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jcraft.jsch.ChannelExec");
                }
                ChannelExec channel2 = (ChannelExec)channel;
                channel2.setPty(this.$channelConfig.isPty());
                channel2.setCommand(this.$channelConfig.getCommand());
                InputStream inputStream = null;
                OutputStream outputStream = null;
                InputStream errStream = null;
                if (this.$channelConfig.isAutoOpen()) {
                    inputStream = channel2.getInputStream();
                    outputStream = channel2.getOutputStream();
                    errStream = channel2.getErrStream();
                }
                channel2.connect(this.$channelConfig.getTimeoutInMillis());
                return new ExecChannelImpl(session, channel2, this.$channelConfig.isPty(), inputStream, outputStream, errStream);
            }
            {
                this.$channelConfig = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final SftpChannel sftp(@NotNull SessionConfig sessionConfig, @NotNull SftpChannelConfig channelConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkParameterIsNotNull((Object)channelConfig, (String)"channelConfig");
        SshSessionKey sessionKey = new SshSessionKey(sessionConfig);
        SshConnection sshConnection2 = this.pool.computeIfAbsent(sessionKey, new Function<SshSessionKey, SshConnection>(sessionKey){
            final /* synthetic */ SshSessionKey $sessionKey;

            @NotNull
            public final SshConnection apply(SshSessionKey it) {
                return new SshConnection(this.$sessionKey.getUsername(), this.$sessionKey.getHost(), this.$sessionKey.getPort());
            }
            {
                this.$sessionKey = sshSessionKey;
            }
        });
        return (SftpChannel)sshConnection2.openChannel(sessionConfig, (ChannelFactory)new ChannelFactory<SftpChannel>(channelConfig){
            final /* synthetic */ SftpChannelConfig $channelConfig;

            @NotNull
            public SftpChannel create(@NotNull SshSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                com.jetbrains.plugins.webDeployment.transport.SshConnectionService$Companion.access$getLOG$p(SshConnectionService.Companion).info("Creating sftp channel within " + session);
                Channel channel = session.getRawSession().openChannel(SshConnectionUtil.INSTANCE.getSFTP_CHANNEL_TYPE());
                if (channel == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jcraft.jsch.ChannelSftp");
                }
                ChannelSftp channel2 = (ChannelSftp)channel;
                if (this.$channelConfig.getDecoratorClass() != null) {
                    try {
                        Object[] elements$iv;
                        Class[] classArray = new Class[]{ChannelSftp.class};
                        GenericDeclaration genericDeclaration = this.$channelConfig.getDecoratorClass();
                        Object[] objectArray = elements$iv;
                        void v1 = objectArray;
                        Constructor<?> c = ((Class)genericDeclaration).getConstructor((Class[])Arrays.copyOf(v1, ((void)v1).length));
                        elements$iv = new Object[]{channel2};
                        genericDeclaration = c;
                        objectArray = elements$iv;
                        T t = ((Constructor)genericDeclaration).newInstance(Arrays.copyOf(objectArray, objectArray.length));
                        if (t == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.jcraft.jsch.ChannelSftp");
                        }
                        channel2 = (ChannelSftp)t;
                    }
                    catch (Exception c) {
                        // empty catch block
                    }
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                if (this.$channelConfig.isAutoOpen()) {
                    inputStream = channel2.getInputStream();
                    outputStream = channel2.getOutputStream();
                }
                channel2.connect(this.$channelConfig.getTimeoutInMillis());
                return new SftpChannelImpl(session, channel2, inputStream, outputStream);
            }
            {
                this.$channelConfig = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final ShellChannel shell(@NotNull SessionConfig sessionConfig, @NotNull ShellChannelConfig channelConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkParameterIsNotNull((Object)channelConfig, (String)"channelConfig");
        return (ShellChannel)this.openChannel(sessionConfig, (ChannelFactory)new ChannelFactory<ShellChannel>(channelConfig){
            final /* synthetic */ ShellChannelConfig $channelConfig;

            @NotNull
            public ShellChannel create(@NotNull SshSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                com.jetbrains.plugins.webDeployment.transport.SshConnectionService$Companion.access$getLOG$p(SshConnectionService.Companion).info("Creating shell channel within " + session);
                Channel channel = session.getRawSession().openChannel(SshConnectionUtil.INSTANCE.getSHELL_CHANNEL_TYPE());
                if (channel == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jcraft.jsch.ChannelShell");
                }
                ChannelShell channel2 = (ChannelShell)channel;
                InputStream inputStream = null;
                OutputStream outputStream = null;
                channel2.setPty(this.$channelConfig.isPty());
                channel2.setPtyType("xterm-256color");
                channel2.setEnv("LANG", "en_US.UTF-8");
                if (this.$channelConfig.isAutoOpen()) {
                    inputStream = channel2.getInputStream();
                    outputStream = channel2.getOutputStream();
                }
                channel2.connect(this.$channelConfig.getTimeoutInMillis());
                return new ShellChannelImpl(session, channel2, inputStream, outputStream);
            }
            {
                this.$channelConfig = $captured_local_variable$0;
            }
        });
    }

    private final <R extends SshChannel> R openChannel(SessionConfig sessionConfig, ChannelFactory<? extends R> channelCreator) throws SshTransportException {
        SshSessionKey sessionKey = new SshSessionKey(sessionConfig);
        SshConnection sshConnection2 = this.pool.computeIfAbsent(sessionKey, new Function<SshSessionKey, SshConnection>(sessionKey){
            final /* synthetic */ SshSessionKey $sessionKey;

            @NotNull
            public final SshConnection apply(SshSessionKey it) {
                return new SshConnection(this.$sessionKey.getUsername(), this.$sessionKey.getHost(), this.$sessionKey.getPort());
            }
            {
                this.$sessionKey = sshSessionKey;
            }
        });
        return sshConnection2.openChannel(sessionConfig, channelCreator);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(SshConnectionService.class);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugins/webDeployment/transport/SshConnectionService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "instance", "Lcom/jetbrains/plugins/webDeployment/transport/SshConnectionService;", "getInstance", "()Lcom/jetbrains/plugins/webDeployment/transport/SshConnectionService;", "webDeployment"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final SshConnectionService getInstance() {
            Object object = ServiceManager.getService(SshConnectionService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ctionService::class.java)");
            return (SshConnectionService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

