/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jetbrains.plugins.webDeployment.transport.ChannelFactory;
import com.jetbrains.plugins.webDeployment.transport.SshChannel;
import com.jetbrains.plugins.webDeployment.transport.SshConnectionUtilKt;
import com.jetbrains.plugins.webDeployment.transport.SshTransportException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000fH\u0007J \u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000fH\u0007J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0006\u0010\u001c\u001a\u00020\u0017J'\u0010\u001d\u001a\u0002H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!H\u0001\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010%\u001a\u00020\u0006H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\b\u00a8\u0006'"}, d2={"Lcom/jetbrains/plugins/webDeployment/transport/SshSession;", "", "rawSession", "Lcom/jcraft/jsch/Session;", "(Lcom/jcraft/jsch/Session;)V", "host", "", "getHost", "()Ljava/lang/String;", "isConnected", "", "()Z", "isDisconnecting", "Ljava/util/concurrent/atomic/AtomicBoolean;", "port", "", "getPort", "()I", "getRawSession", "()Lcom/jcraft/jsch/Session;", "userName", "getUserName", "addLocalTunnel", "", "localPort", "remotePort", "addRemoteTunnel", "delPortForwardingL", "disconnect", "openChannel", "C", "Lcom/jetbrains/plugins/webDeployment/transport/SshChannel;", "channelCreator", "Lcom/jetbrains/plugins/webDeployment/transport/ChannelFactory;", "openChannel$webDeployment", "(Lcom/jetbrains/plugins/webDeployment/transport/ChannelFactory;)Lcom/jetbrains/plugins/webDeployment/transport/SshChannel;", "removeLocalTunnel", "toString", "Companion", "webDeployment"})
public final class SshSession {
    private final AtomicBoolean isDisconnecting;
    @NotNull
    private final Session rawSession;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final <C extends SshChannel> C openChannel$webDeployment(@NotNull ChannelFactory<? extends C> channelCreator) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull(channelCreator, (String)"channelCreator");
        try {
            return channelCreator.create(this);
        }
        catch (JSchException e) {
            throw (Throwable)new SshTransportException(e.getMessage(), e);
        }
    }

    public final void addRemoteTunnel(int remotePort, @NotNull String host, int localPort) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        SshSession.Companion.getLOG().debug("Adding remote tunnel " + host + ":" + localPort + " <= " + remotePort + " for " + this);
        try {
            this.rawSession.setPortForwardingR(remotePort, host, localPort);
        }
        catch (JSchException e) {
            throw (Throwable)new SshTransportException("Failed to add remote port forwarding", e);
        }
    }

    public final void addLocalTunnel(int localPort, @NotNull String host, int remotePort) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        SshSession.Companion.getLOG().debug("Adding local tunnel " + localPort + " => " + host + ":" + remotePort + " for " + this);
        try {
            this.rawSession.setPortForwardingL(localPort, host, remotePort);
        }
        catch (JSchException e) {
            throw (Throwable)new SshTransportException("Failed to add local port forwarding", e);
        }
    }

    @Deprecated(message="Use removeLocalTunnel() instead", replaceWith=@ReplaceWith(imports={}, expression="removeLocalTunnel()"))
    public final void delPortForwardingL(int port) throws JSchException {
        SshSession.Companion.getLOG().debug("Deleting local tunnel bound to local port " + port);
        this.rawSession.delPortForwardingL(port);
    }

    public final void removeLocalTunnel(int port) throws SshTransportException {
        SshSession.Companion.getLOG().debug("Deleting local tunnel bound to local port " + port);
        try {
            this.rawSession.delPortForwardingL(port);
        }
        catch (JSchException e) {
            throw (Throwable)new SshTransportException("Failed to delete local port forwarding");
        }
    }

    public final void disconnect() {
        if (this.isDisconnecting.compareAndSet(false, true)) {
            SshSession.Companion.getLOG().debug("Disconnecting " + this);
            this.rawSession.disconnect();
        }
    }

    @NotNull
    public String toString() {
        return "SSH session " + SshConnectionUtilKt.id(this) + " to " + this.getUserName() + "@" + this.getHost() + ":" + this.getPort();
    }

    @NotNull
    public final String getUserName() {
        String string = this.rawSession.getUserName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rawSession.userName");
        return string;
    }

    @NotNull
    public final String getHost() {
        String string = this.rawSession.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rawSession.host");
        return string;
    }

    public final int getPort() {
        return this.rawSession.getPort();
    }

    public final boolean isConnected() {
        return this.rawSession.isConnected();
    }

    @NotNull
    public final Session getRawSession() {
        return this.rawSession;
    }

    public SshSession(@NotNull Session rawSession) {
        Intrinsics.checkParameterIsNotNull((Object)rawSession, (String)"rawSession");
        this.rawSession = rawSession;
        this.isDisconnecting = new AtomicBoolean(false);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SshSession.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(SshSession::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/plugins/webDeployment/transport/SshSession$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "webDeployment"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

