/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.BackgroundOperatingDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.reference.SoftReference;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.SyncLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.CompositeDiffElement;
import com.jetbrains.plugins.webDeployment.ui.LocalItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteReadOnlyVirtualFile;
import com.jetbrains.plugins.webDeployment.ui.SyncLoadComponent;
import com.jetbrains.plugins.webDeployment.ui.SyncUtils;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteItemDiffElement
extends DiffElement<FileObject>
implements BackgroundOperatingDiffElement,
RemoteDiffElement {
    private static final Logger LOG = Logger.getInstance((String)RemoteItemDiffElement.class.getName());
    private static final RemoteItemDiffElement[] EMPTY = new RemoteItemDiffElement[0];
    public static final int UNKNOWN_VALUE = -1;
    private static final long MAX_SIZE = 0x100000L;
    private final AtomicBoolean myOperationRunning;
    private final Project myProject;
    private final RemoteConnection myConnection;
    private final PublishConfig myConfig;
    private final Deployable myServer;
    private final FileObject myFile;
    private final FileType myFileType;
    private final DirDiffSettings mySettings;
    private final String myName;
    private final boolean myIsRoot;
    private long mySize;
    private long myLastModified;
    private boolean myExcluded;
    private final DeploymentPathMapping myMapping;
    private SoftReference<byte[]> myCachedContent;
    private RemoteItemDiffElement[] myCachedChildren;
    private RemoteItemDiffElement[] myCachedExcludedChildren;

    public RemoteItemDiffElement(RemoteConnection connection, Deployable server, FileObject file, Project project, PublishConfig config, boolean excluded, DeploymentPathMapping mapping, DirDiffSettings settings, @NotNull String name, boolean isRoot) throws FileSystemException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "<init>"));
        }
        this.myOperationRunning = new AtomicBoolean(false);
        this.myConnection = connection;
        this.myServer = server;
        this.myFile = file;
        this.myProject = project;
        this.myExcluded = excluded;
        this.myMapping = mapping;
        this.myConfig = config;
        this.mySettings = settings;
        this.myName = name;
        this.myIsRoot = isRoot;
        this.myFileType = ServerTreeNode.getFileType(file);
        if (FileType.IMAGINARY != this.myFileType) {
            FileContent content = file.getContent();
            this.myLastModified = content.getLastModifiedTime(this.myServer.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER);
            this.mySize = this.myFileType.hasContent() ? content.getSize() : 0L;
        } else {
            this.myLastModified = -1L;
            this.mySize = 0L;
        }
    }

    public RemoteItemDiffElement(RemoteConnection connection, Deployable server, FileObject file, Project project, PublishConfig config, boolean excluded, DeploymentPathMapping mapping, DirDiffSettings settings, boolean isRoot) throws FileSystemException {
        this(connection, server, file, project, config, excluded, mapping, settings, CompositeDiffElement.getSimpleRootName(file), isRoot);
    }

    public String getPath() {
        return this.myServer.getPresentablePath(this.myFile);
    }

    public String getPresentablePath() {
        return WDBundle.message("remote.diff.title.0.on.server.1", this.getShortPresentablePath(), this.myServer.getName());
    }

    protected String getShortPresentablePath() {
        return this.myServer.getPresentablePath(this.myFile);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getName"));
        }
        return string;
    }

    public long getSize() {
        if (this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return -1L;
        }
        return this.mySize;
    }

    public long getTimeStamp() {
        long result = this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings) ? -1L : this.myLastModified;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp of " + this.myServer.getPresentablePath(this.myFile) + " is " + this.myLastModified);
        }
        return result;
    }

    public boolean isContainer() {
        return this.myFileType.hasChildren();
    }

    public RemoteItemDiffElement[] getChildren() throws IOException {
        boolean showExcluded;
        LOG.assertTrue(this.isContainer());
        if (this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return EMPTY;
        }
        boolean bl = showExcluded = !SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings);
        if (this.myCachedChildren == null || showExcluded && this.myCachedExcludedChildren == null) {
            FileObject[] children;
            if (this.myFile.isSymbolicLink()) {
                this.myCachedChildren = new RemoteItemDiffElement[0];
                this.myCachedExcludedChildren = new RemoteItemDiffElement[0];
                return EMPTY;
            }
            try {
                children = ServerTreeNode.getChildren(this.myFile, this.myServer, (ThrowableComputable<RemoteConnection, FileSystemException>)((ThrowableComputable)() -> this.myConnection));
            }
            catch (CustomFileSystemException e) {
                throw new IOException(e.getMessage(), (Throwable)((Object)e));
            }
            if (children.length == 0) {
                return EMPTY;
            }
            ArrayList result = new ArrayList(children.length);
            ArrayList excludedResult = new ArrayList(children.length);
            try {
                for (FileObject child : children) {
                    this.myConnection.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> {
                        boolean excluded = SyncUtils.isExcludedRemoteOrCorresponding(child, this.myMapping, this.myServer, this.myConfig, this.mySettings);
                        if (!excluded) {
                            result.add(new RemoteItemDiffElement(this.myConnection, this.myServer, child, this.myProject, this.myConfig, excluded, this.myMapping, this.mySettings, false));
                        } else if (showExcluded) {
                            excludedResult.add(new RemoteItemDiffElement(this.myConnection, this.myServer, child, this.myProject, this.myConfig, excluded, this.myMapping, this.mySettings, false));
                        }
                    }), null);
                }
            }
            catch (FileSystemException e) {
                throw new IOException(e.getMessage(), e);
            }
            this.myCachedChildren = result.toArray(new RemoteItemDiffElement[result.size()]);
            if (showExcluded) {
                this.myCachedExcludedChildren = excludedResult.toArray(new RemoteItemDiffElement[excludedResult.size()]);
            }
        }
        if (!showExcluded) {
            return this.myCachedChildren;
        }
        RemoteItemDiffElement[] result = new RemoteItemDiffElement[this.myCachedChildren.length + this.myCachedExcludedChildren.length];
        System.arraycopy(this.myCachedChildren, 0, result, 0, this.myCachedChildren.length);
        System.arraycopy(this.myCachedExcludedChildren, 0, result, this.myCachedChildren.length, this.myCachedExcludedChildren.length);
        return result;
    }

    @Nullable
    public byte[] getContent() throws IOException {
        if (this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return null;
        }
        if (this.myFileType == FileType.IMAGINARY) {
            throw new IOException(WDBundle.message("file.0.can.not.be.found", this.myServer.getPresentablePath(this.myFile)));
        }
        if (RemoteItemDiffElement.isTooBig(this)) {
            return null;
        }
        byte[] result = this.getCachedRemoteContent();
        if (result == null) {
            Pair resultPair = (Pair)this.myConnection.executeServerOperationSilently(() -> {
                try {
                    return new Pair((Object)FileTransferUtil.getContent(this.myFile, null), null);
                }
                catch (IOException e) {
                    return new Pair(null, (Object)e);
                }
            }, null);
            if (resultPair.getSecond() != null) {
                throw (IOException)resultPair.getSecond();
            }
            result = (byte[])resultPair.getFirst();
            this.myCachedContent = new SoftReference((Object)result);
            return result;
        }
        return result;
    }

    public FileObject getValue() {
        return this.myFile;
    }

    public Icon getIcon() {
        Icon basicIcon;
        Icon icon = basicIcon = this.isContainer() ? PlatformIcons.FOLDER_ICON : this.getFileType().getIcon();
        if (this.myFileType == FileType.IMAGINARY) {
            return new LayeredIcon(new Icon[]{basicIcon, AllIcons.General.WarningDecorator});
        }
        return basicIcon;
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        DiffContent diffContent;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "createDiffContent"));
        }
        try {
            LOG.assertTrue(!this.isExcluded() || !SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings));
            if (RemoteItemDiffElement.isTooBig(this)) {
                String message = WDBundle.message("can.not.build.diff.for.file.0.file.is.too.big.and.there.are.too.many.changes", this.getPath());
                throw new DiffRequestProducerException(message);
            }
            if (this.myFileType == FileType.IMAGINARY) {
                String message = WDBundle.message("can.not.provide.content.of.file.0.probably.it.s.a.recursive.symlink", this.getPath());
                throw new DiffRequestProducerException(message);
            }
            byte[] content = this.getContent();
            if (content == null) {
                throw new DiffRequestProducerException("Can't get content");
            }
            diffContent = DiffContentFactory.getInstance().create(project, this.getVirtualFile(content));
        }
        catch (IOException e) {
            throw new DiffRequestProducerException((Throwable)e);
        }
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "createDiffContent"));
        }
        return diffContent;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getProject"));
        }
        return project;
    }

    public void copyTo(DiffElement container, final Ref<String> errorMessage, final Ref<DiffElement> diffElement, final Runnable onFinish, final DiffElement targetElement, String path) {
        FileDocumentManager documentManager;
        Document document;
        if (this.myExcluded) {
            return;
        }
        LOG.assertTrue(container instanceof LocalItemDiffElement || container instanceof CompositeDiffElement.LocalCompositeDiffElement, container.getClass());
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getShortPresentablePath());
            return;
        }
        final String localPath = this.myMapping.mapToLocalPath(this.myFile, (Mappable)this.myServer);
        VirtualFile childFile = LocalFileSystem.getInstance().findFileByPath(localPath);
        if (childFile != null && (document = (documentManager = FileDocumentManager.getInstance()).getDocument(childFile)) != null) {
            documentManager.saveDocument(document);
        }
        SyncLoadComponent component = (SyncLoadComponent)this.mySettings.customSettings.get("syncLoadComponent");
        FileObject target = DeploymentPathUtils.getLocalFile(localPath);
        if (target == null) {
            LOG.warn("No child for download");
            String message = this.getErrorMessage();
            errorMessage.set((Object)message);
            component.reportSkipping(message);
            onFinish.run();
            this.myOperationRunning.set(false);
            return;
        }
        TransferOperation.Copy operation = new TransferOperation.Copy(this.myFile, target){

            @Override
            public void execute(ExecutionContext context) throws FileSystemException {
                try {
                    if (targetElement != null) {
                        context.setIgnoreOverwriting(true);
                    }
                    super.execute(context);
                    VirtualFile child = LocalFileSystem.getInstance().refreshAndFindFileByPath(localPath);
                    if (child == null) {
                        errorMessage.set((Object)WDBundle.message("failed.to.create.local.file.0", localPath));
                    } else {
                        LocalItemDiffElement element = LocalItemDiffElement.createLocalElement(child, RemoteItemDiffElement.this.myMapping, RemoteItemDiffElement.this.myConfig, RemoteItemDiffElement.this.myServer, RemoteItemDiffElement.this.mySettings, RemoteItemDiffElement.this.myProject);
                        diffElement.set((Object)element);
                    }
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    errorMessage.set((Object)WDBundle.message("failed.to.download.file.0", RemoteItemDiffElement.this.getPresentablePath()));
                    throw e;
                }
                finally {
                    context.setIgnoreOverwriting(false);
                    ApplicationManager.getApplication().invokeAndWait(onFinish);
                    RemoteItemDiffElement.this.myOperationRunning.set(false);
                }
            }
        };
        component.offerTransferOperation(operation, false);
    }

    private String getErrorMessage() {
        return WDBundle.message("failed.to.copy.file.0.1", this.getShortPresentablePath(), WDBundle.message("destination.differs.from.mapped.destination", new Object[0]));
    }

    public void delete(final Ref<String> errorMessage, final Runnable onFinish) {
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getShortPresentablePath());
            return;
        }
        if (this.myExcluded) {
            LOG.debug("Excluded " + this.getPresentablePath());
            return;
        }
        SyncLoadComponent component = (SyncLoadComponent)this.mySettings.customSettings.get("syncLoadComponent");
        TransferOperation.Delete operation = new TransferOperation.Delete(this.myFile, false, true){

            @Override
            public void execute(ExecutionContext context) throws FileSystemException {
                try {
                    super.execute(context);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    errorMessage.set((Object)WDBundle.message("failed.to.delete.remote.file.0", RemoteItemDiffElement.this.getPresentablePath()));
                    throw e;
                }
                finally {
                    ApplicationManager.getApplication().invokeAndWait(onFinish);
                    RemoteItemDiffElement.this.myOperationRunning.set(false);
                }
            }
        };
        component.offerTransferOperation(operation, true);
    }

    @Override
    @NotNull
    public RemoteConnection getConnection() {
        RemoteConnection remoteConnection = this.myConnection;
        if (remoteConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getConnection"));
        }
        return remoteConnection;
    }

    @Nullable
    public byte[] getCachedRemoteContent() {
        return (byte[])SoftReference.dereference(this.myCachedContent);
    }

    public boolean isOperationsEnabled() {
        if (this.myIsRoot) {
            return true;
        }
        if (this.myExcluded || this.myOperationRunning.get() || this.myFileType == FileType.IMAGINARY) {
            return false;
        }
        String localPath = this.myMapping.mapToLocalPath(this.myFile, (Mappable)this.myServer);
        return !this.myConfig.isExcludedByName(localPath) && !PublishConfig.isLocalPathExcluded(localPath, this.myServer, this.myConfig) && !SyncUtils.isLocalPathExcludedFromProject(localPath, this.mySettings);
    }

    public DiffElement<?> copyTo(DiffElement container, String relativePath) {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.copyTo()");
    }

    public boolean delete() {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.delete()");
    }

    protected boolean isExcluded() {
        return this.myExcluded;
    }

    public void refresh(boolean userInitiated) throws IOException {
        if (userInitiated && this.myFileType != FileType.IMAGINARY) {
            try {
                this.myConnection.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> {
                    FilesCache cache = PublishUtils.getManager().getFilesCache();
                    FileSystem fs = this.myFile.getFileSystem();
                    RemoteItemDiffElement.clearFileSystemCache(this, cache, fs);
                    this.myFile.refresh();
                    FileContent content = this.myFile.getContent();
                    this.myLastModified = content.getLastModifiedTime(this.myServer.getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER);
                    this.mySize = this.myFileType.hasContent() ? content.getSize() : 0L;
                    this.myCachedChildren = null;
                    this.myCachedExcludedChildren = null;
                    this.myCachedContent = null;
                    this.myExcluded = Boolean.TRUE.booleanValue() == this.myConfig.isExcludedByName(this.myServer.getPresentablePath(this.myFile));
                }), null);
            }
            catch (FileSystemException e) {
                LOG.warn((Throwable)e);
                throw new IOException(PublishUtils.getMessage(e, true), e);
            }
        }
    }

    private static void clearFileSystemCache(RemoteItemDiffElement element, FilesCache cache, FileSystem fileSystem) {
        cache.removeFile(fileSystem, element.getValue().getName());
        if (element.isContainer() && element.myCachedChildren != null) {
            for (RemoteItemDiffElement child : element.myCachedChildren) {
                RemoteItemDiffElement.clearFileSystemCache(child, cache, fileSystem);
            }
        }
    }

    public void reset(long size, long timestamp, @Nullable byte[] content) {
        this.mySize = size;
        this.myLastModified = timestamp;
        this.myCachedContent = content != null ? new SoftReference((Object)content) : null;
        this.myCachedChildren = null;
        this.myCachedExcludedChildren = null;
    }

    private VirtualFile getVirtualFile(byte[] content) {
        String localPath = this.myMapping.mapToLocalPath(this.myFile, (Mappable)this.myServer);
        VirtualFile localFile = LocalFileSystem.getInstance().findFileByPath(localPath);
        Charset charset = localFile == null ? EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset() : localFile.getCharset();
        return new RemoteReadOnlyVirtualFile(this.myFile, content, false, charset);
    }

    public static boolean isTooBig(DiffElement element) {
        return element.getSize() > 0x100000L;
    }

    public String toString() {
        return "RemoteItemDiffElement{name=" + this.getName() + '}';
    }
}

