/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.auth;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.ui.LoginForm;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

class LoginDialog
extends DialogWrapper {
    private LoginForm myForm;
    private AsyncPromise<Boolean> myResult = new AsyncPromise();

    public static LoginDialog createInstance(Connectable connectable, @NotNull ConnectionOwner connectionOwner, boolean modal) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/auth/LoginDialog", "createInstance"));
        }
        Component parentComponent = connectionOwner.getComponentForDialogCreation();
        if (parentComponent != null) {
            return new LoginDialog(connectable, parentComponent, modal);
        }
        return new LoginDialog(connectable, connectionOwner.getProjectForDialogCreation(), modal);
    }

    public LoginDialog(Connectable connectable, @Nullable Project project, boolean modal) {
        super(project, false);
        this.initialize(connectable, modal);
    }

    public LoginDialog(Connectable connectable, Component parent, boolean modal) {
        super(parent, false);
        this.initialize(connectable, modal);
    }

    private void initialize(Connectable connectable, boolean modal) {
        this.setModal(modal);
        String name = connectable.getName();
        if (StringUtil.isEmpty((String)name)) {
            name = connectable.getHost();
        }
        this.setTitle(WDBundle.message("login.dialog.title", name, connectable.getAccessType().getTitle()));
        this.myForm = new LoginForm(connectable);
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myForm.getContentPane();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    public String getUsername() {
        return this.myForm.getUsername();
    }

    public String getPassword() {
        return this.myForm.getPassword();
    }

    public boolean isSavePassword() {
        return this.myForm.isSavePassword();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myResult.setResult((Object)true);
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.myResult.setResult((Object)false);
    }

    protected String getDimensionServiceKey() {
        return "publish.login";
    }

    public Promise<Boolean> showAndGetResult() {
        this.show();
        return this.myResult;
    }
}

