/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabStub;
import com.jetbrains.plugins.webDeployment.ui.config.ExcludedPathsConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SharedDataHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludedPathsConfigurableTabProvider
implements DeploymentConfigurableTabProvider {
    @Override
    public DeploymentConfigurableTab createTab(@Nullable Project project, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedData", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider", "createTab"));
        }
        if (project != null && !project.isDefault()) {
            return new ExcludedPathsConfigurableTab(project, serverStateProvider, sharedData);
        }
        return new DeploymentConfigurableTabStub(ExcludedPathsConfigurableTab.TITLE, 2, WDBundle.message("excluded.paths.tab.stub.text", new Object[0]));
    }

    @Override
    public void copyData(Project project, SettingsDeployable from, SettingsDeployable to, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedData", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider", "copyData"));
        }
        if (project == null || project.isDefault()) {
            return;
        }
        sharedData.getExcludedPaths().put(to.getId(), sharedData.getExcludedPaths().get(from.getId()));
    }

    @Override
    public boolean dataIsEqual(Project project, SettingsDeployable o1, SettingsDeployable o2, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedData", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider", "dataIsEqual"));
        }
        if (project == null || project.isDefault()) {
            return true;
        }
        List<ExcludedPath> ex1 = sharedData.getExcludedPaths().get(o1.getId());
        List<ExcludedPath> ex2 = sharedData.getExcludedPaths().get(o2.getId());
        return Comparing.equal(ex1, ex2);
    }

    @Override
    public boolean isNonServerDataModified(Project project, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedData", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider", "isNonServerDataModified"));
        }
        return false;
    }

    @Override
    public void reset(Project project, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedData", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider", "reset"));
        }
        if (project == null || project.isDefault()) {
            return;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        HashMap<String, List<ExcludedPath>> excludedPaths = new HashMap<String, List<ExcludedPath>>();
        for (WebServerConfig server : WebServersConfigManager.getInstance(project).getServers(false)) {
            excludedPaths.put(server.getId(), publishConfig.getExcludedPaths(server.getId()));
        }
        sharedData.setExcludedPaths(excludedPaths);
    }

    @Override
    public void apply(Project project, List<SettingsDeployable> currentServers, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedData", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider", "apply"));
        }
        if (project == null || project.isDefault()) {
            return;
        }
        PublishConfig config = PublishConfig.getInstance(project);
        Map<String, List<ExcludedPath>> paths = sharedData.getExcludedPaths();
        config.setExcludedPaths(DeploymentConfigurable.filterExistingServers(paths, currentServers));
    }

    @Override
    public void onItemCreated(Project project, SettingsDeployable newItem, List<SettingsDeployable> currentItems, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedData", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider", "onItemCreated"));
        }
    }

    @Override
    public void onItemDeleted(Project project, SettingsDeployable item, List<SettingsDeployable> currentItems, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedData", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider", "onItemDeleted"));
        }
        if (project == null || project.isDefault()) {
            return;
        }
        sharedData.getExcludedPaths().remove(item.getId());
    }

    @Override
    public void createActions(boolean fromPopup, Project project, ArrayList<AnAction> result, Computable<SettingsDeployable> selectionProvider, Runnable updater, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedData", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider", "createActions"));
        }
    }

    @Override
    public boolean isDisplayInBold(Project project, SettingsDeployable item, @NotNull SharedDataHolder sharedData) {
        if (sharedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedData", "com/jetbrains/plugins/webDeployment/ui/config/ExcludedPathsConfigurableTabProvider", "isDisplayInBold"));
        }
        return false;
    }
}

