/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd;

import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.RemoteMoveProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemotePasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/RemotePasteProvider", "performPaste"));
        }
        boolean[] copied = new boolean[1];
        PsiElement element = RemoteMoveProvider.getPsiElementWithData(copied);
        if (element == null) {
            return;
        }
        PsiDirectory target = RemotePasteProvider.extractTargetDirectory(dataContext);
        if (target != null) {
            RemoteMoveProvider.performRemoteToLocalPaste(element, (PsiElement)target, !copied[0]);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/RemotePasteProvider", "isPastePossible"));
        }
        return this.isPasteEnabled(dataContext);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/RemotePasteProvider", "isPasteEnabled"));
        }
        PsiDirectory target = RemotePasteProvider.extractTargetDirectory(dataContext);
        if (target == null) {
            return false;
        }
        return RemoteMoveProvider.isFromRemotePasteEnabled(dataContext, false);
    }

    @Nullable
    private static PsiDirectory extractTargetDirectory(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/RemotePasteProvider", "extractTargetDirectory"));
        }
        PsiElement target = (PsiElement)LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
        if (target instanceof PsiDirectory) {
            return (PsiDirectory)target;
        }
        if (target instanceof PsiFile) {
            return ((PsiFile)target).getContainingDirectory();
        }
        if (target instanceof PsiDirectoryContainer) {
            Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
            PsiDirectory[] directories = module != null ? ((PsiDirectoryContainer)target).getDirectories(GlobalSearchScope.moduleScope((Module)module)) : ((PsiDirectoryContainer)target).getDirectories();
            if (directories.length == 1) {
                return directories[0];
            }
            return null;
        }
        return null;
    }
}

