/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionManager;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkSessionManager {
    public static SshRemoteSession checkConnectionAndGetSession(final @Nullable Project project, final @NotNull RemoteSdkCredentials data) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/SdkSessionManager", "checkConnectionAndGetSession"));
        }
        final Checker checker = new Checker();
        Task.Modal task = new Task.Modal(project, "Connecting to " + data.getHost(), true){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/remotesdk/SdkSessionManager$1", "run"));
                }
                checker.work(pi, data, project);
            }

            public void onCancel() {
                checker.setError(new RemoteCancelledException("Connection was canceled."));
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/jetbrains/plugins/remotesdk/SdkSessionManager$1", "onThrowable"));
                }
                checker.setError(error);
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            ApplicationManager.getApplication().invokeAndWait(() -> ProgressManager.getInstance().run((Task)task));
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        return SdkSessionManager.processResult(data, checker);
    }

    public static SshRemoteSession checkConnectionAndGetSessionInBackground(@Nullable Project project, @NotNull RemoteSdkCredentials data) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/SdkSessionManager", "checkConnectionAndGetSessionInBackground"));
        }
        Checker checker = new Checker();
        checker.work(ProgressManager.getInstance().getProgressIndicator(), data, project);
        return SdkSessionManager.processResult(data, checker);
    }

    @NotNull
    private static SshRemoteSession processResult(@NotNull RemoteSdkCredentials data, Checker checker) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/SdkSessionManager", "processResult"));
        }
        Throwable error = checker.getException();
        if (error != null) {
            throw new RemoteSdkException("Error connecting to remote host:" + data.getHost(), error);
        }
        SshRemoteSession session = checker.getSession();
        if (session == null) {
            throw new RemoteSdkException("Couldn't create remote session for " + data.getHost());
        }
        SshRemoteSession sshRemoteSession = session;
        if (sshRemoteSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/SdkSessionManager", "processResult"));
        }
        return sshRemoteSession;
    }

    private static class Checker {
        private final AtomicReference<Throwable> myException = new AtomicReference();
        private final AtomicReference<Boolean> myResult = new AtomicReference<Boolean>(false);
        private final AtomicReference<SshRemoteSession> mySession = new AtomicReference();

        private Checker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void work(@Nullable ProgressIndicator pi, @NotNull RemoteSdkCredentials data, @Nullable Project project) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/SdkSessionManager$Checker", "work"));
            }
            Semaphore done = new Semaphore();
            done.down();
            EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(RemoteConnectionManager.ForceDisconnectListener.class);
            SshConnectionManager connectionManager = SshConnectionManager.getInstance();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/SdkSessionManager$Checker", "lambda$work$0"));
                }
                Ref error = new Ref();
                Ref result = new Ref();
                Ref session = new Ref();
                try {
                    SshRemoteSession s;
                    if (pi != null) {
                        pi.setText("Connecting to " + data.getHost() + "...");
                    }
                    if (RemoteSdkUtil.checkInterpreterAndCreateHelpersFolder(data, (Ref<Exception>)error, (Ref<Boolean>)result, null, s = connectionManager.getSession(project, (RemoteCredentials)data))) {
                        session.set((Object)s);
                    }
                }
                catch (Exception e) {
                    error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
                }
                finally {
                    this.myException.set((Throwable)error.get());
                    this.myResult.set((Boolean)result.get());
                    this.mySession.set((SshRemoteSession)session.get());
                    done.up();
                }
            });
            try {
                while (!done.waitFor(100L)) {
                    if (pi == null) continue;
                    pi.checkCanceled();
                }
            }
            finally {
                ((RemoteConnectionManager.ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
            }
        }

        public void setError(Throwable e) {
            this.myException.compareAndSet(null, e);
        }

        public Throwable getException() {
            return this.myException.get();
        }

        public Boolean getResult() {
            return this.myResult.get();
        }

        public SshRemoteSession getSession() {
            return this.mySession.get();
        }
    }
}

