/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.google.common.collect.Lists;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashMap;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionUtil;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteConnectionSettingsForm {
    public static final RemoteConnector NONE_CONNECTOR = new RemoteConnector(){

        public String getId() {
            return null;
        }

        @NotNull
        public String getName() {
            if ("Select server on every run" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm$1", "getName"));
            }
            return "Select server on every run";
        }

        @NotNull
        public RemoteConnectionType getType() {
            RemoteConnectionType remoteConnectionType = RemoteConnectionType.NONE;
            if (remoteConnectionType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm$1", "getType"));
            }
            return remoteConnectionType;
        }

        public void produceRemoteCredentials(Consumer<RemoteCredentials> remoteCredentialsConsumer) {
            remoteCredentialsConsumer.consume(null);
        }

        @NotNull
        public Object getConnectorKey() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm$1", "getConnectorKey"));
            }
            return "";
        }

        public String toString() {
            return this.getName();
        }
    };
    private Map<RemoteConnectionType, JRadioButton> myAdditionalConnectors;
    private ComboBox myConnectionsCombo;
    private JRadioButton myServer;
    private JPanel myMainPanel;
    private JBLabel myDeploymentServersLink;
    private JPanel myAdditionalConnectorsPlaceholder;
    @Nullable
    private final Project myProject;
    private boolean myShowServerSettingsLink = false;
    private final Disposable myParentDisposable;

    public RemoteConnectionSettingsForm(@Nullable Project project, Disposable parentDisposable) {
        this.myProject = project;
        this.myParentDisposable = parentDisposable;
        this.$$$setupUI$$$();
    }

    public JComponent createPanel() {
        final MutableCollectionComboBoxModel model = new MutableCollectionComboBoxModel(RemoteConnectionSettingsForm.collectConnectionVariants(this.myProject));
        ApplicationManager.getApplication().getMessageBus().connect(this.myParentDisposable).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            public void deploymentConfigChanged() {
                model.update(RemoteConnectionSettingsForm.collectConnectionVariants(RemoteConnectionSettingsForm.this.myProject));
            }
        });
        this.myConnectionsCombo.setModel((ComboBoxModel)model);
        this.myConnectionsCombo.setSelectedItem(model.getSize() > 0 ? model.getElementAt(0) : null);
        this.myConnectionsCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<RemoteConnector>(){

            public void customize(JList list, RemoteConnector value, int index, boolean selected, boolean hasFocus) {
                this.setText(value != null ? value.getName() : "(none)");
            }
        });
        this.setupConfigureServersLink((JLabel)this.myDeploymentServersLink);
        ButtonGroup group = new ButtonGroup();
        group.add(this.myServer);
        for (JRadioButton button : this.myAdditionalConnectors.values()) {
            group.add(button);
        }
        return this.myMainPanel;
    }

    private void setupConfigureServersLink(JLabel label) {
        if (this.myShowServerSettingsLink) {
            label.setText("<html><a href=\"#\">Configure Servers");
            label.setCursor(Cursor.getPredefinedCursor(12));
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    Settings settings;
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm$4", "onClick"));
                    }
                    if (clickCount == 1 && (settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)RemoteConnectionSettingsForm.this.myMainPanel))) != null) {
                        settings.select(settings.find("web.server"));
                        return true;
                    }
                    return false;
                }
            }.installOn((Component)label);
        } else {
            label.setVisible(false);
        }
    }

    public void setConnectionTypeAndId(@Nullable RemoteConnectionType type, String id) {
        if (type == null || type == RemoteConnectionType.NONE) {
            this.myServer.setSelected(true);
            this.setConnectorSelectionById(type, NONE_CONNECTOR.getId());
            return;
        }
        JRadioButton radioButton = this.myAdditionalConnectors.get(type);
        if (radioButton != null) {
            radioButton.setSelected(true);
            return;
        }
        this.myServer.setSelected(true);
        this.setConnectorSelectionById(type, id);
    }

    private void setConnectorSelectionById(@Nullable RemoteConnectionType type, String id) {
        List<RemoteConnector> connectors = RemoteConnectionSettingsForm.collectConnectionVariants(this.myProject);
        for (int i = 0; i < connectors.size(); ++i) {
            RemoteConnector c = connectors.get(i);
            if (type != c.getType() || (id != null || c.getId() != null) && (id == null || !id.equals(c.getId()))) continue;
            this.myConnectionsCombo.setSelectedIndex(i);
            break;
        }
    }

    @Nullable
    private RemoteConnector getSelected() {
        Object o = this.myConnectionsCombo.getSelectedItem();
        if (o instanceof RemoteConnector) {
            return (RemoteConnector)o;
        }
        return null;
    }

    @NotNull
    public RemoteConnectionType getConnectionType() {
        RemoteConnector connector;
        if (this.myServer.isSelected() && (connector = this.getSelected()) != null) {
            RemoteConnectionType remoteConnectionType = connector.getType();
            if (remoteConnectionType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm", "getConnectionType"));
            }
            return remoteConnectionType;
        }
        for (Map.Entry<RemoteConnectionType, JRadioButton> entry : this.myAdditionalConnectors.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            RemoteConnectionType remoteConnectionType = entry.getKey();
            if (remoteConnectionType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm", "getConnectionType"));
            }
            return remoteConnectionType;
        }
        RemoteConnectionType remoteConnectionType = RemoteConnectionType.NONE;
        if (remoteConnectionType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/RemoteConnectionSettingsForm", "getConnectionType"));
        }
        return remoteConnectionType;
    }

    public String getConnectionId() {
        RemoteConnector connector;
        if (this.myServer.isSelected() && (connector = this.getSelected()) != null) {
            return connector.getId();
        }
        return "";
    }

    private static List<RemoteConnector> collectConnectionVariants(@Nullable Project project) {
        ArrayList result = Lists.newArrayList();
        result.add(NONE_CONNECTOR);
        result.addAll(RemoteConnectionUtil.getAllRemoteConnectors(project));
        return result;
    }

    public void setShowServerSettingsLink(boolean showServerSettingsLink) {
        this.myShowServerSettingsLink = showServerSettingsLink;
    }

    private void createUIComponents() {
        this.myAdditionalConnectorsPlaceholder = new JPanel();
        SshConnectionProvider[] extensions = (SshConnectionProvider[])SshConnectionProvider.EP_NAME.getExtensions();
        int number = extensions.length;
        this.myAdditionalConnectors = new HashMap();
        if (number > 0) {
            this.myAdditionalConnectorsPlaceholder.setLayout(new BoxLayout(this.myAdditionalConnectorsPlaceholder, 1));
            boolean row = false;
            for (SshConnectionProvider provider : extensions) {
                JRadioButton button = new JRadioButton(provider.getRadioButtonDescription());
                this.myAdditionalConnectors.put(provider.getTypeForConfigurable(), button);
                this.myAdditionalConnectorsPlaceholder.add(button);
            }
        } else {
            this.myAdditionalConnectorsPlaceholder.setVisible(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JRadioButton jRadioButton;
        ComboBox comboBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Connection settings", (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myConnectionsCombo = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, new Dimension(40, -1), null, null));
        this.myServer = jRadioButton = new JRadioButton();
        jRadioButton.setText("Deployment server");
        jRadioButton.setActionCommand("Deployment server");
        jRadioButton.setLabel("Deployment server");
        jRadioButton.putClientProperty("hideActionText", Boolean.TRUE);
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDeploymentServersLink = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = this.myAdditionalConnectorsPlaceholder;
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

