/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.console.RemoteDataProducer;
import com.jetbrains.plugins.remotesdk.console.SshConsoleOptionsProvider;
import com.jetbrains.plugins.remotesdk.console.SshTerminalCachingRunner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalView;

public class RunSshConsoleAction
extends AnAction
implements DumbAware {
    private static final Logger LOGGER = Logger.getInstance(RunSshConsoleAction.class);

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(AnActionEvent e) {
        this.runSshConsole(e);
    }

    public void runSshConsole(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        SshConsoleOptionsProvider optionsProvider = SshConsoleOptionsProvider.getInstance(project);
        new RemoteDataProducer().withActionEvent(event).withShowProjectLevelServers(true).produceRemoteData(optionsProvider.getConnectionType(), optionsProvider.getConnectionId(), (Consumer<RemoteCredentials>)((Consumer)data -> {
            SshTerminalCachingRunner runner = new SshTerminalCachingRunner(project, (RemoteCredentials)data, optionsProvider.getCharset());
            UIUtil.invokeLaterIfNeeded(() -> RunSshConsoleAction.connectToSshUnderProgress(project, runner, data));
        }));
    }

    private static void connectToSshUnderProgress(final Project project, final SshTerminalCachingRunner runner, final RemoteCredentials data) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Connecting to " + runner.runningTargetName(), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction$1", "run"));
                }
                RunSshConsoleAction.createTerminalSession(indicator, runner, data, project, this.getTitle());
            }
        });
    }

    private static void createTerminalSession(@NotNull ProgressIndicator indicator, SshTerminalCachingRunner runner, RemoteCredentials data, Project project, String title) {
        block3: {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/plugins/remotesdk/console/RunSshConsoleAction", "createTerminalSession"));
            }
            try {
                runner.getAndCacheSession(data);
            }
            catch (RemoteSdkException e) {
                if (indicator.isCanceled()) break block3;
                LOGGER.warn("unable to get session for " + data, (Throwable)e);
                UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)title));
            }
        }
        UIUtil.invokeLaterIfNeeded(() -> TerminalView.getInstance((Project)project).createNewSession(project, (AbstractTerminalRunner)runner));
    }
}

