/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.plugins.remotesdk.console.SshConsoleOptionsProvider;
import com.jetbrains.plugins.remotesdk.console.SshConsoleSettingsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SshConsoleOptionsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
Disposable {
    public static final String CONSOLE_SETTINGS_HELP_REFERENCE = "reference.settings.ssh.terminal";
    private SshConsoleSettingsPanel myPanel;
    private final SshConsoleOptionsProvider myOptionsProvider;
    private Project myProject;

    public SshConsoleOptionsConfigurable(Project project) {
        this.myOptionsProvider = SshConsoleOptionsProvider.getInstance(project);
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        if ("sshConsole" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/console/SshConsoleOptionsConfigurable", "getId"));
        }
        return "sshConsole";
    }

    @Nls
    public String getDisplayName() {
        return "SSH Terminal";
    }

    public String getHelpTopic() {
        return CONSOLE_SETTINGS_HELP_REFERENCE;
    }

    public JComponent createComponent() {
        this.myPanel = new SshConsoleSettingsPanel(this, this.myProject);
        return this.myPanel.createPanel(this.myOptionsProvider);
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        this.myPanel = null;
    }
}

