/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.jetbrains.plugins.remotesdk.ConnectionOwnerFactory;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionManager;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionServiceUtil;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.transport.SshSessionKey;
import com.jetbrains.plugins.webDeployment.transport.SshTransportException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConnectionManagerImpl
extends SshConnectionManager {
    private final Map<SshSessionKey, SshRemoteSession> myPoolMap = new ConcurrentHashMap<SshSessionKey, SshRemoteSession>();

    @Override
    @NotNull
    public SshRemoteSession getSession(@NotNull RemoteCredentials data) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getSession"));
        }
        SshRemoteSession sshRemoteSession = this.getSession(null, data, 60L, TimeUnit.SECONDS);
        if (sshRemoteSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getSession"));
        }
        return sshRemoteSession;
    }

    @Override
    public SshRemoteSession getSession(@Nullable Project project, @NotNull RemoteCredentials data) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getSession"));
        }
        return this.getSession(project, data, 60L, TimeUnit.SECONDS);
    }

    @Override
    public SshRemoteSession getSession(@Nullable Project project, @NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getSession"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "getSession"));
        }
        ConnectionOwner owner = ConnectionOwnerFactory.createConnectionOwner((Project)null);
        try {
            SshSessionKey sshSessionKey = SshConnectionServiceUtil.INSTANCE.remoteCredentialsToSessionKey(data);
            return this.myPoolMap.computeIfAbsent(sshSessionKey, s -> {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/transport/SshConnectionManagerImpl", "lambda$getSession$0"));
                }
                return new SshRemoteSession(owner, data);
            });
        }
        catch (SshTransportException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
    }
}

