/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.DefaultXmlSuppressionProvider;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSuppressableInspectionTool
extends LocalInspectionTool
implements BatchSuppressableTool {
    @NonNls
    static final String ALL = "ALL";

    @NotNull
    public static SuppressQuickFix[] getSuppressFixes(@NotNull String toolId) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
        }
        SuppressQuickFix[] suppressQuickFixArray = XmlSuppressableInspectionTool.getSuppressFixes(toolId, new DefaultXmlSuppressionProvider());
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
        }
        return suppressQuickFixArray;
    }

    @NotNull
    public static SuppressQuickFix[] getSuppressFixes(@NotNull String toolId, @NotNull XmlSuppressionProvider provider) {
        if (toolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolId", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new SuppressTagStatic(toolId, provider), new SuppressForFile(toolId, provider), new SuppressAllForFile(provider)};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool", "getSuppressFixes"));
        }
        return suppressQuickFixArray;
    }

    public static class SuppressAllForFile
    extends SuppressForFile {
        public SuppressAllForFile(XmlSuppressionProvider provider) {
            super(XmlSuppressableInspectionTool.ALL, provider);
        }

        public SuppressAllForFile() {
            super(XmlSuppressableInspectionTool.ALL);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("xml.suppressable.all.for.file.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressAllForFile", "getName"));
            }
            return string;
        }
    }

    public static class SuppressForFile
    extends XmlSuppressFix {
        public SuppressForFile(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            super(inspectionId, suppressionProvider);
        }

        public SuppressForFile(String id) {
            super(id);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("xml.suppressable.for.file.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressForFile", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElement container = this.getContainer(element);
            if (container instanceof XmlFile) {
                this.myProvider.suppressForFile(element, this.myId);
            }
        }

        @Override
        @Nullable
        public PsiElement getContainer(@Nullable PsiElement context) {
            return context == null || !context.isValid() ? null : context.getContainingFile();
        }
    }

    public static class SuppressTagStatic
    extends XmlSuppressFix {
        public SuppressTagStatic(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            super(inspectionId, suppressionProvider);
        }

        public SuppressTagStatic(String id) {
            super(id);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message("xml.suppressable.for.tag.title", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/XmlSuppressableInspectionTool$SuppressTagStatic", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (PsiTreeUtil.getParentOfType(element, XmlTag.class) == null) {
                return;
            }
            this.myProvider.suppressForTag(element, this.myId);
        }

        @Override
        @Nullable
        public PsiElement getContainer(@Nullable PsiElement context) {
            return PsiTreeUtil.getParentOfType(context, XmlTag.class);
        }
    }

    public static abstract class XmlSuppressFix
    implements InjectionAwareSuppressQuickFix,
    ContainerBasedSuppressQuickFix {
        protected final String myId;
        protected final XmlSuppressionProvider myProvider;
        private ThreeState myShouldBeAppliedToInjectionHost = ThreeState.UNSURE;

        protected XmlSuppressFix(String inspectionId, XmlSuppressionProvider suppressionProvider) {
            this.myId = inspectionId;
            this.myProvider = suppressionProvider;
        }

        protected XmlSuppressFix(String id) {
            this(id, new DefaultXmlSuppressionProvider());
        }

        @Override
        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/XmlSuppressableInspectionTool$XmlSuppressFix", "isAvailable"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/XmlSuppressableInspectionTool$XmlSuppressFix", "isAvailable"));
            }
            return context.isValid() && this.getContainer(context) != null;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$XmlSuppressFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @Nullable
        public PsiElement getContainer(@Nullable PsiElement context) {
            return null;
        }

        @Override
        @NotNull
        public ThreeState isShouldBeAppliedToInjectionHost() {
            ThreeState threeState = this.myShouldBeAppliedToInjectionHost;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/XmlSuppressableInspectionTool$XmlSuppressFix", "isShouldBeAppliedToInjectionHost"));
            }
            return threeState;
        }

        @Override
        public void setShouldBeAppliedToInjectionHost(@NotNull ThreeState shouldBeAppliedToInjectionHost) {
            if (shouldBeAppliedToInjectionHost == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldBeAppliedToInjectionHost", "com/intellij/codeInspection/XmlSuppressableInspectionTool$XmlSuppressFix", "setShouldBeAppliedToInjectionHost"));
            }
            this.myShouldBeAppliedToInjectionHost = shouldBeAppliedToInjectionHost;
        }

        @Override
        public boolean isSuppressAll() {
            return false;
        }
    }
}

