/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public abstract class CompatibleRunConfigurationProducer<T extends RunConfiguration>
extends RunConfigurationProducer<T> {
    protected CompatibleRunConfigurationProducer(@NotNull ConfigurationType configurationType) {
        if (configurationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationType", "com/intellij/execution/actions/CompatibleRunConfigurationProducer", "<init>"));
        }
        super(configurationType);
    }

    @Override
    protected boolean setupConfigurationFromContext(T configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (configuration == null || context == null || sourceElement == null || !this.isContextCompatible(context)) {
            return false;
        }
        return this.setupConfigurationFromCompatibleContext(configuration, context, sourceElement);
    }

    protected abstract boolean setupConfigurationFromCompatibleContext(@NotNull T var1, @NotNull ConfigurationContext var2, @NotNull Ref<PsiElement> var3);

    @Override
    public final boolean isConfigurationFromContext(T configuration, ConfigurationContext context) {
        if (configuration == null || context == null || !this.isContextCompatible(context)) {
            return false;
        }
        return this.isConfigurationFromCompatibleContext(configuration, context);
    }

    protected abstract boolean isConfigurationFromCompatibleContext(@NotNull T var1, @NotNull ConfigurationContext var2);

    protected boolean isContextCompatible(@NotNull ConfigurationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/CompatibleRunConfigurationProducer", "isContextCompatible"));
        }
        ConfigurationType type = this.getConfigurationType();
        return context.isCompatibleWithOriginalRunConfiguration(type);
    }
}

