/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class CapturingAnsiEscapesAwareProcessHandler
extends CapturingProcessHandler {
    public CapturingAnsiEscapesAwareProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/CapturingAnsiEscapesAwareProcessHandler", "<init>"));
        }
        super(commandLine);
    }

    @Deprecated
    public CapturingAnsiEscapesAwareProcessHandler(Process process) {
        super(process);
    }

    public CapturingAnsiEscapesAwareProcessHandler(@NotNull Process process, @NotNull String commandLine) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/CapturingAnsiEscapesAwareProcessHandler", "<init>"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/CapturingAnsiEscapesAwareProcessHandler", "<init>"));
        }
        super(process, null, commandLine);
    }

    @Override
    protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
        return new AnsiEscapesAwareAdapter(processOutput);
    }

    protected static class AnsiEscapesAwareAdapter
    extends CapturingProcessAdapter
    implements AnsiEscapeDecoder.ColoredTextAcceptor {
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder(){

            @Override
            @NotNull
            protected Key getCurrentOutputAttributes(@NotNull Key outputType) {
                if (outputType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/intellij/execution/process/CapturingAnsiEscapesAwareProcessHandler$AnsiEscapesAwareAdapter$1", "getCurrentOutputAttributes"));
                }
                Key key = outputType;
                if (key == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/CapturingAnsiEscapesAwareProcessHandler$AnsiEscapesAwareAdapter$1", "getCurrentOutputAttributes"));
                }
                return key;
            }
        };

        public AnsiEscapesAwareAdapter(ProcessOutput output) {
            super(output);
        }

        @Override
        public void onTextAvailable(ProcessEvent event, Key outputType) {
            this.myAnsiEscapeDecoder.escapeText(event.getText(), outputType, this);
        }

        @Override
        public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/process/CapturingAnsiEscapesAwareProcessHandler$AnsiEscapesAwareAdapter", "coloredTextAvailable"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/execution/process/CapturingAnsiEscapesAwareProcessHandler$AnsiEscapesAwareAdapter", "coloredTextAvailable"));
            }
            this.addToOutput(text, attributes);
        }
    }
}

