/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.firefox;

import com.intellij.ide.browsers.firefox.FirefoxProfile;
import com.intellij.ide.browsers.firefox.FirefoxSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirefoxUtil {
    private static final Logger LOG = Logger.getInstance(FirefoxUtil.class);
    @NonNls
    public static final String PROFILES_INI_FILE = "profiles.ini";

    private FirefoxUtil() {
    }

    @Nullable
    public static File getDefaultProfileIniPath() {
        File[] roots;
        for (File profilesDir : roots = FirefoxUtil.getProfilesDirs()) {
            File profilesFile = new File(profilesDir, PROFILES_INI_FILE);
            if (!profilesFile.isFile()) continue;
            return profilesFile;
        }
        return null;
    }

    @Nullable
    public static File getFirefoxExtensionsDir(FirefoxSettings settings) {
        File profilesFile = settings.getProfilesIniFile();
        if (profilesFile != null && profilesFile.exists()) {
            File profileDir;
            List<FirefoxProfile> profiles = FirefoxUtil.computeProfiles(profilesFile);
            FirefoxProfile profile = FirefoxUtil.findProfileByNameOrDefault(settings.getProfile(), profiles);
            if (profile != null && (profileDir = profile.getProfileDirectory(profilesFile)).isDirectory()) {
                return new File(profileDir, "extensions");
            }
        }
        return null;
    }

    @Nullable
    public static FirefoxProfile findProfileByNameOrDefault(@Nullable String name, @NotNull List<FirefoxProfile> profiles) {
        if (profiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profiles", "com/intellij/ide/browsers/firefox/FirefoxUtil", "findProfileByNameOrDefault"));
        }
        for (FirefoxProfile profile : profiles) {
            if (!profile.getName().equals(name)) continue;
            return profile;
        }
        return FirefoxUtil.getDefaultProfile(profiles);
    }

    @Nullable
    public static FirefoxProfile getDefaultProfile(List<FirefoxProfile> profiles) {
        if (profiles.isEmpty()) {
            return null;
        }
        for (FirefoxProfile profile : profiles) {
            if (!profile.isDefault()) continue;
            return profile;
        }
        return profiles.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static List<FirefoxProfile> computeProfiles(@Nullable File profilesFile) {
        if (profilesFile == null || !profilesFile.isFile()) {
            List<FirefoxProfile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/firefox/FirefoxUtil", "computeProfiles"));
            }
            return list;
        }
        BufferedReader reader = new BufferedReader(new FileReader(profilesFile));
        SmartList profiles = new SmartList();
        boolean insideProfile = false;
        String currentName = null;
        String currentPath = null;
        boolean isDefault = false;
        boolean isRelative = false;
        boolean eof = false;
        while (!eof) {
            String line = reader.readLine();
            if (line == null) {
                eof = true;
                line = "[]";
            } else {
                line = line.trim();
            }
            if (line.startsWith("[") && line.endsWith("]")) {
                if (!StringUtil.isEmpty(currentPath) && !StringUtil.isEmpty(currentName)) {
                    profiles.add(new FirefoxProfile(currentName, currentPath, isDefault, isRelative));
                }
                currentName = null;
                currentPath = null;
                isDefault = false;
                isRelative = false;
                insideProfile = StringUtil.startsWithIgnoreCase((String)line, (String)"[Profile");
                continue;
            }
            int i2 = line.indexOf(61);
            if (i2 == -1 || !insideProfile) continue;
            String name = line.substring(0, i2).trim();
            String value = line.substring(i2 + 1).trim();
            if (name.equalsIgnoreCase("path")) {
                currentPath = value;
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                currentName = value;
                continue;
            }
            if (name.equalsIgnoreCase("default") && value.equals("1")) {
                isDefault = true;
                continue;
            }
            if (!name.equalsIgnoreCase("isrelative") || !value.equals("1")) continue;
            isRelative = true;
        }
        SmartList smartList = profiles;
        reader.close();
        SmartList smartList2 = smartList;
        if (smartList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/firefox/FirefoxUtil", "computeProfiles"));
        }
        return smartList2;
        {
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    List<FirefoxProfile> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/firefox/FirefoxUtil", "computeProfiles"));
                    }
                    return list;
                }
            }
        }
    }

    private static File[] getProfilesDirs() {
        String userHome = SystemProperties.getUserHome();
        if (SystemInfo.isMac) {
            return new File[]{new File(userHome, "Library" + File.separator + "Mozilla" + File.separator + "Firefox"), new File(userHome, "Library" + File.separator + "Application Support" + File.separator + "Firefox")};
        }
        if (SystemInfo.isUnix) {
            return new File[]{new File(userHome, ".mozilla" + File.separator + "firefox")};
        }
        String localPath = "Mozilla" + File.separator + "Firefox";
        return new File[]{new File(System.getenv("APPDATA"), localPath), new File(userHome, "AppData" + File.separator + "Roaming" + File.separator + localPath), new File(userHome, "Application Data" + File.separator + localPath)};
    }
}

