/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;

public abstract class WriteAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.WriteAction");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RunResult<T> execute() {
        RunResult result = new RunResult(this);
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            AccessToken token = WriteAction.start(this.getClass());
            try {
                result.run();
            }
            finally {
                token.finish();
            }
            RunResult runResult = result;
            if (runResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "execute"));
            }
            return runResult;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        TransactionGuard.getInstance().submitTransactionAndWait(() -> {
            AccessToken token = WriteAction.start(this.getClass());
            try {
                result.run();
            }
            finally {
                token.finish();
            }
        });
        if (!this.isSilentExecution()) {
            result.throwException();
        }
        RunResult runResult = result;
        if (runResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "execute"));
        }
        return runResult;
    }

    @Deprecated
    @NotNull
    public static AccessToken start() {
        AccessToken accessToken = WriteAction.start((Class)ObjectUtils.notNull((Object)ReflectionUtil.getGrandCallerClass(), WriteAction.class));
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "start"));
        }
        return accessToken;
    }

    @Deprecated
    @NotNull
    public static AccessToken start(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/application/WriteAction", "start"));
        }
        AccessToken accessToken = ApplicationManager.getApplication().acquireWriteActionLock(clazz);
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "start"));
        }
        return accessToken;
    }

    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> action) throws E {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/WriteAction", "run"));
        }
        AccessToken token = WriteAction.start();
        try {
            action.run();
        }
        finally {
            token.finish();
        }
    }

    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> action) throws E {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/application/WriteAction", "compute"));
        }
        AccessToken token = WriteAction.start();
        try {
            Object object = action.compute();
            return (T)object;
        }
        finally {
            token.finish();
        }
    }
}

