/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CaretVisualAttributes {
    public static final CaretVisualAttributes DEFAULT = new CaretVisualAttributes(null, Weight.NORMAL);
    @Nullable
    private final Color myColor;
    @NotNull
    private final Weight myWeight;

    public CaretVisualAttributes(@Nullable Color color, @NotNull Weight weight) {
        if (weight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "weight", "com/intellij/openapi/editor/CaretVisualAttributes", "<init>"));
        }
        this.myColor = color;
        this.myWeight = weight;
    }

    @Nullable
    public Color getColor() {
        return this.myColor;
    }

    @NotNull
    public Weight getWeight() {
        Weight weight = this.myWeight;
        if (weight == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/CaretVisualAttributes", "getWeight"));
        }
        return weight;
    }

    public int getWidth(int defaultWidth) {
        return Math.max(1, defaultWidth + this.myWeight.delta);
    }

    public static enum Weight {
        THIN(-1),
        NORMAL(0),
        HEAVY(1);

        private final int delta;

        private Weight(int delta) {
            this.delta = delta;
        }

        public int getDelta() {
            return this.delta;
        }
    }
}

