/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ExternalSystemUiAware {
    @NotNull
    public String getProjectRepresentationName(@NotNull String var1, @Nullable String var2);

    @NotNull
    default public String getProjectRepresentationName(@NotNull Project project, @NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/ExternalSystemUiAware", "getProjectRepresentationName"));
        }
        if (targetProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetProjectPath", "com/intellij/openapi/externalSystem/ExternalSystemUiAware", "getProjectRepresentationName"));
        }
        String string = this.getProjectRepresentationName(targetProjectPath, rootProjectPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/ExternalSystemUiAware", "getProjectRepresentationName"));
        }
        return string;
    }

    @Nullable
    public FileChooserDescriptor getExternalProjectConfigDescriptor();

    @Nullable
    public Icon getProjectIcon();

    @Nullable
    public Icon getTaskIcon();
}

