/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectPojo
implements Comparable<ExternalProjectPojo> {
    @NotNull
    private String myName;
    @NotNull
    private String myPath;

    public ExternalProjectPojo() {
        this("___DUMMY___", "___DUMMY___");
    }

    public ExternalProjectPojo(@NotNull String name, @NotNull String path2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/project/ExternalProjectPojo", "<init>"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/model/project/ExternalProjectPojo", "<init>"));
        }
        this.myName = name;
        this.myPath = path2;
    }

    @NotNull
    public static <T extends Named & ExternalConfigPathAware> ExternalProjectPojo from(@NotNull T data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/model/project/ExternalProjectPojo", "from"));
        }
        String projectUniqueName = StringUtil.isEmpty((String)((Identifiable)data).getId()) ? data.getExternalName() : ((Identifiable)data).getId();
        ExternalProjectPojo externalProjectPojo = new ExternalProjectPojo(projectUniqueName, ((ExternalConfigPathAware)data).getLinkedExternalProjectPath());
        if (externalProjectPojo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ExternalProjectPojo", "from"));
        }
        return externalProjectPojo;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ExternalProjectPojo", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/project/ExternalProjectPojo", "setName"));
        }
        this.myName = name;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ExternalProjectPojo", "getPath"));
        }
        return string;
    }

    public void setPath(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/model/project/ExternalProjectPojo", "setPath"));
        }
        this.myPath = path2;
    }

    @Override
    public int compareTo(@NotNull ExternalProjectPojo that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/externalSystem/model/project/ExternalProjectPojo", "compareTo"));
        }
        return this.myName.compareTo(that.myName);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalProjectPojo pojo = (ExternalProjectPojo)o;
        if (!this.myName.equals(pojo.myName)) {
            return false;
        }
        return this.myPath.equals(pojo.myPath);
    }

    public String toString() {
        return this.myName;
    }
}

