/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.util;

import com.intellij.ide.DataManager;
import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.ActualZoomAction;
import com.intellij.openapi.graph.builder.actions.DeleteSelectionAction;
import com.intellij.openapi.graph.builder.actions.FitContentAction;
import com.intellij.openapi.graph.builder.actions.ShowHideGridAction;
import com.intellij.openapi.graph.builder.actions.SnapToGridAction;
import com.intellij.openapi.graph.builder.actions.ZoomInAction;
import com.intellij.openapi.graph.builder.actions.ZoomOutAction;
import com.intellij.openapi.graph.builder.actions.export.ExportToFileAction;
import com.intellij.openapi.graph.builder.actions.layout.ApplyCurrentLayoutAction;
import com.intellij.openapi.graph.builder.actions.printing.PrintGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.PrintPreviewAction;
import com.intellij.openapi.graph.builder.util.CompositeDataProvider;
import com.intellij.openapi.graph.builder.util.CustomGraphActionsFactory;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphViewUtil {
    private static volatile boolean ourPrintMode = false;
    public static final StructureViewModel MODEL = new StructureViewModel(){

        @Override
        @Nullable
        public Object getCurrentEditorElement() {
            return null;
        }

        @Override
        public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1", "addEditorPositionListener"));
            }
        }

        @Override
        public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1", "removeEditorPositionListener"));
            }
        }

        @Override
        public void addModelListener(@NotNull ModelListener modelListener) {
            if (modelListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1", "addModelListener"));
            }
        }

        @Override
        public void removeModelListener(@NotNull ModelListener modelListener) {
            if (modelListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1", "removeModelListener"));
            }
        }

        @Override
        @NotNull
        public StructureViewTreeElement getRoot() {
            StructureViewTreeElement structureViewTreeElement = new StructureViewTreeElement(){

                @Override
                public Object getValue() {
                    return null;
                }

                @Override
                public void navigate(boolean requestFocus) {
                }

                @Override
                public boolean canNavigate() {
                    return false;
                }

                @Override
                public boolean canNavigateToSource() {
                    return false;
                }

                @Override
                @NotNull
                public ItemPresentation getPresentation() {
                    if (null == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1$1", "getPresentation"));
                    }
                    return null;
                }

                @Override
                @NotNull
                public TreeElement[] getChildren() {
                    if (EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1$1", "getChildren"));
                    }
                    return EMPTY_ARRAY;
                }
            };
            if (structureViewTreeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1", "getRoot"));
            }
            return structureViewTreeElement;
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean shouldEnterElement(Object element) {
            return false;
        }

        @Override
        @NotNull
        public Grouper[] getGroupers() {
            if (Grouper.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1", "getGroupers"));
            }
            return Grouper.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public Sorter[] getSorters() {
            if (Sorter.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1", "getSorters"));
            }
            return Sorter.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public Filter[] getFilters() {
            if (Filter.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$1", "getFilters"));
            }
            return Filter.EMPTY_ARRAY;
        }
    };
    @NonNls
    public static String GRAPH_KEY = "GRAPH_KEY";
    private static final StructureViewModel DUMMY_MODEL = new StructureViewModel(){

        @Override
        public Object getCurrentEditorElement() {
            return null;
        }

        @Override
        public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/graph/builder/util/GraphViewUtil$4", "addEditorPositionListener"));
            }
        }

        @Override
        public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/graph/builder/util/GraphViewUtil$4", "removeEditorPositionListener"));
            }
        }

        @Override
        public void addModelListener(@NotNull ModelListener modelListener) {
            if (modelListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/openapi/graph/builder/util/GraphViewUtil$4", "addModelListener"));
            }
        }

        @Override
        public void removeModelListener(@NotNull ModelListener modelListener) {
            if (modelListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/openapi/graph/builder/util/GraphViewUtil$4", "removeModelListener"));
            }
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean shouldEnterElement(Object element) {
            return false;
        }

        @Override
        @NotNull
        public StructureViewTreeElement getRoot() {
            StructureViewTreeElement structureViewTreeElement = new StructureViewTreeElement(){

                @Override
                public Object getValue() {
                    return null;
                }

                @Override
                public void navigate(boolean requestFocus) {
                }

                @Override
                public boolean canNavigate() {
                    return false;
                }

                @Override
                public boolean canNavigateToSource() {
                    return false;
                }

                @Override
                @NotNull
                public ItemPresentation getPresentation() {
                    if (null == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$4$1", "getPresentation"));
                    }
                    return null;
                }

                @Override
                @NotNull
                public TreeElement[] getChildren() {
                    if (EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$4$1", "getChildren"));
                    }
                    return EMPTY_ARRAY;
                }
            };
            if (structureViewTreeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$4", "getRoot"));
            }
            return structureViewTreeElement;
        }

        @Override
        @NotNull
        public Grouper[] getGroupers() {
            if (Grouper.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$4", "getGroupers"));
            }
            return Grouper.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public Sorter[] getSorters() {
            if (Sorter.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$4", "getSorters"));
            }
            return Sorter.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public Filter[] getFilters() {
            if (Filter.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$4", "getFilters"));
            }
            return Filter.EMPTY_ARRAY;
        }
    };

    public static boolean isPrintMode() {
        return ourPrintMode;
    }

    public static void setPrintMode(boolean printMode) {
        ourPrintMode = printMode;
    }

    @Nullable
    public static Object getData(Graph2DView view, String data) {
        DataProvider dataProvider = DataManager.getDataProvider(view.getJComponent());
        if (dataProvider == null) {
            return null;
        }
        return dataProvider.getData(data);
    }

    public static Graph2DView createView(DataProvider dataProvider) {
        Graph2DView graph2DView = GraphManager.getGraphManager().createGraph2DView();
        GraphViewUtil.addDataProvider(graph2DView, dataProvider);
        return graph2DView;
    }

    public static void addDataProvider(Graph2DView graph2DView, @NotNull DataProvider dataProvider) {
        CompositeDataProvider compositeDataProvider;
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/openapi/graph/builder/util/GraphViewUtil", "addDataProvider"));
        }
        DataProvider oldDataProvider = DataManager.getDataProvider(graph2DView.getJComponent());
        if (oldDataProvider == null) {
            compositeDataProvider = new CompositeDataProvider();
            compositeDataProvider.add(GraphViewUtil.createDefaultGraphDataProvider(graph2DView));
        } else if (oldDataProvider instanceof CompositeDataProvider) {
            compositeDataProvider = (CompositeDataProvider)oldDataProvider;
        } else {
            compositeDataProvider = new CompositeDataProvider();
            compositeDataProvider.add(oldDataProvider);
        }
        compositeDataProvider.add(dataProvider);
        DataManager.registerDataProvider(graph2DView.getJComponent(), compositeDataProvider);
    }

    private static DataProvider createDefaultGraphDataProvider(final Graph2DView graph2DView) {
        return new DataProvider(){

            @Override
            @Nullable
            public Object getData(@NonNls String dataId) {
                if (GRAPH_KEY.equals(dataId)) {
                    return graph2DView.getGraph2D();
                }
                return null;
            }
        };
    }

    public static List<Node> getSelectedNodes(Graph2D graph) {
        return ContainerUtil.findAll((Object[])graph.getNodeArray(), node -> graph.getRealizer((Node)node).isSelected());
    }

    public static List<Edge> getSelectedEdges(Graph2D graph) {
        return ContainerUtil.findAll((Object[])graph.getEdgeArray(), edge -> graph.getRealizer((Edge)edge).isSelected());
    }

    public static NodeRealizer createNodeRealizer(@NonNls String configuration, NodeCellRenderer nodeCellRenderer) {
        GenericNodeRealizer nodeRealizer = GraphManager.getGraphManager().createGenericNodeRealizer();
        GenericNodeRealizer.Factory factory = GenericNodeRealizer.Statics.getFactory();
        Map map = factory.createDefaultConfigurationMap();
        map.put(GenericNodeRealizer.Painter.class, GraphManager.getGraphManager().createNodeCellRendererPainter(nodeCellRenderer, NodeCellRendererPainter.USER_DATA_MAP));
        factory.addConfiguration(configuration, map);
        nodeRealizer.setConfiguration(configuration);
        nodeRealizer.setUserData(nodeCellRenderer);
        return nodeRealizer;
    }

    public static void setRenderedNodeSizes(Graph2D graph, Graph2DView view, Node node) {
        NodeLabel nodeLabel;
        GroupNodeRealizer groupNodeRealizer;
        GenericNodeRealizer realizer;
        Object o;
        NodeRealizer nodeRealizer = graph.getRealizer(node);
        if (nodeRealizer instanceof GenericNodeRealizer && (o = (realizer = (GenericNodeRealizer)nodeRealizer).getUserData()) instanceof NodeCellRenderer) {
            Dimension size = ((NodeCellRenderer)o).getNodeCellRendererComponent(view, nodeRealizer, null, false).getPreferredSize();
            graph.setSize(nodeRealizer.getNode(), GraphManager.getGraphManager().createYDimension(size.width, size.height));
        }
        if (nodeRealizer instanceof GroupNodeRealizer && (groupNodeRealizer = (GroupNodeRealizer)nodeRealizer).isGroupClosed() && (nodeLabel = groupNodeRealizer.getLabel()) != null) {
            graph.setSize(node, nodeLabel.getWidth(), groupNodeRealizer.getHeight());
        }
    }

    public static JComponent createCommonToolbarPane(GraphBuilder graphBuilder) {
        DefaultActionGroup actions = GraphViewUtil.getBasicToolbar(graphBuilder);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", actions, true);
        return actionToolbar.getComponent();
    }

    public static DefaultActionGroup getBasicToolbar(Graph2D graph) {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add(new ShowHideGridAction(graph));
        actions.add(new SnapToGridAction(graph));
        actions.addSeparator();
        actions.add(new ZoomInAction(graph));
        actions.add(new ZoomOutAction(graph));
        actions.add(new ActualZoomAction(graph));
        actions.add(new FitContentAction(graph));
        actions.addSeparator();
        actions.add(new ApplyCurrentLayoutAction(graph));
        actions.addSeparator();
        actions.add(new ExportToFileAction(graph));
        actions.add(new PrintGraphAction(graph));
        actions.add(new PrintPreviewAction(graph));
        actions.addSeparator();
        actions.add(new DeleteSelectionAction());
        actions.addSeparator();
        return actions;
    }

    public static DefaultActionGroup getBasicToolbar(GraphBuilder builder) {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add(CustomGraphActionsFactory.getInstance().getActions(builder));
        actions.add(GraphViewUtil.getBasicToolbar(builder.getGraph()));
        return actions;
    }

    public static AnAction getCommonPopupActions() {
        return ActionManager.getInstance().getAction("Graph.DefaultGraphPopup");
    }

    public static void updateWorldRect(Graph2DView view) {
        Rectangle rectangle = GraphViewUtil.getActualSize(view);
        int x = (int)rectangle.getX() - 20;
        int y = (int)rectangle.getY() - 20;
        int width = (int)rectangle.getWidth() + 40;
        int hight = (int)rectangle.getHeight() + 40;
        view.setWorldRect(x, y, width, hight);
    }

    public static Rectangle getActualSize(Graph2DView view) {
        return view.getGraph2D().getBoundingBox();
    }

    public static StructureViewBuilder createStructureViewBuilder(final Overview overview) {
        DefaultBackgroundRenderer renderer = GraphManager.getGraphManager().createDefaultBackgroundRenderer(overview);
        renderer.setColor(UIUtil.getListBackground());
        overview.setBackgroundRenderer(renderer);
        return new StructureViewBuilder(){

            @Override
            @NotNull
            public StructureView createStructureView(final FileEditor fileEditor, @NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/graph/builder/util/GraphViewUtil$3", "createStructureView"));
                }
                StructureView structureView = new StructureView(){

                    @Override
                    public FileEditor getFileEditor() {
                        return fileEditor;
                    }

                    @Override
                    public boolean navigateToSelectedElement(boolean requestFocus) {
                        return false;
                    }

                    @Override
                    public JComponent getComponent() {
                        return overview.getJComponent();
                    }

                    public void dispose() {
                    }

                    @Override
                    public void centerSelectedRow() {
                    }

                    @Override
                    public void restoreState() {
                    }

                    @Override
                    public void storeState() {
                    }

                    @Override
                    @NotNull
                    public StructureViewModel getTreeModel() {
                        StructureViewModel structureViewModel = DUMMY_MODEL;
                        if (structureViewModel == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$3$1", "getTreeModel"));
                        }
                        return structureViewModel;
                    }
                };
                if (structureView == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/builder/util/GraphViewUtil$3", "createStructureView"));
                }
                return structureView;
            }
        };
    }

    public static void navigateTo(Object node, GraphBuilder builder) {
        for (Object o : builder.getGraphDataModel().getNodes()) {
            if (!o.equals(node)) continue;
            Node n = builder.getNode(node);
            if (n == null) {
                return;
            }
            for (Node nn : builder.getGraph().getNodeArray()) {
                builder.getGraph().setSelected(nn, nn == n);
            }
            builder.getView().setCenter(builder.getGraph().getCenterX(n), builder.getGraph().getCenterY(n));
        }
    }
}

