/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder.util;

import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.view.Graph2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphState {
    final Map<Object, Point> nodes = new HashMap<Object, Point>();
    final Map<Object, List<Point>> edges = new HashMap<Object, List<Point>>();
    private final GraphBuilder myBuilder;
    private Object center = null;

    public GraphState(GraphBuilder builder) {
        Object r;
        Graph2D graph = builder.getGraph();
        for (Object node : builder.getNodeObjects()) {
            r = graph.getRealizer(builder.getNode(node));
            this.nodes.put(node, new Point(r.getX(), r.getY()));
            if (!graph.isSelected(builder.getNode(node))) continue;
            this.center = node;
        }
        for (Object edge : builder.getEdgeObjects()) {
            r = graph.getRealizer(builder.getEdge(edge));
            ArrayList<Point> points = new ArrayList<Point>();
            for (int i2 = 0; i2 < r.pointCount(); ++i2) {
                YPoint p = r.getPoint(i2);
                points.add(new Point(p.getX(), p.getY()));
            }
            this.edges.put(edge, points);
        }
        this.myBuilder = builder;
    }

    public void restore() {
        Object r;
        Graph2D graph = this.myBuilder.getGraph();
        GraphState state = new GraphState(this.myBuilder);
        Point c = state.nodes.get(this.center);
        double deltaX = c.x - this.nodes.get((Object)this.center).x;
        double deltaY = c.y - this.nodes.get((Object)this.center).y;
        for (Object node : this.myBuilder.getNodeObjects()) {
            r = graph.getRealizer(this.myBuilder.getNode(node));
            Point p = this.nodes.containsKey(node) ? this.nodes.get(node) : new Point(r.getX(), r.getY());
            r.setX(p.x + deltaX);
            r.setY(p.y + deltaY);
        }
        for (Object edge : this.myBuilder.getEdgeObjects()) {
            r = graph.getRealizer(this.myBuilder.getEdge(edge));
            r.clearPoints();
            List<Point> points = this.edges.containsKey(edge) ? this.edges.get(edge) : state.edges.get(edge);
            for (Point p : points) {
                r.addPoint(p.x + deltaX, p.y + deltaY);
            }
        }
    }

    private static class Point {
        final double x;
        final double y;

        public Point(double first, double second) {
            this.x = first;
            this.y = second;
        }
    }
}

