/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SettingsEditorGroup<T>
extends SettingsEditor<T> {
    private final List<Pair<String, SettingsEditor<T>>> myEditors = new ArrayList<Pair<String, SettingsEditor<T>>>();

    public void addEditor(String name, SettingsEditor<T> editor) {
        Disposer.register((Disposable)this, editor);
        this.myEditors.add(Pair.create((Object)name, editor));
    }

    public void addGroup(SettingsEditorGroup<T> group) {
        for (Pair<String, SettingsEditor<T>> pair : group.myEditors) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)pair.second));
        }
        this.myEditors.addAll(group.myEditors);
    }

    public List<Pair<String, SettingsEditor<T>>> getEditors() {
        return this.myEditors;
    }

    @Override
    public void resetEditorFrom(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/options/SettingsEditorGroup", "resetEditorFrom"));
        }
    }

    @Override
    public void applyEditorTo(@NotNull T t) throws ConfigurationException {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/openapi/options/SettingsEditorGroup", "applyEditorTo"));
        }
    }

    @Override
    @NotNull
    public JComponent createEditor() {
        throw new UnsupportedOperationException("This method should never be called!");
    }
}

