/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class SdkVersionUtil {
    private static final JdkVersionDetector.ActionRunner ACTION_RUNNER = r -> ApplicationManager.getApplication().executeOnPooledThread(r);

    private SdkVersionUtil() {
    }

    @Nullable
    public static String readVersionFromProcessOutput(@NotNull String homePath, @NotNull String[] command, String versionLineMarker) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/impl/SdkVersionUtil", "readVersionFromProcessOutput"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/projectRoots/impl/SdkVersionUtil", "readVersionFromProcessOutput"));
        }
        return JdkVersionDetector.getInstance().detectJdkVersion(homePath, ACTION_RUNNER);
    }

    @Nullable
    public static String detectJdkVersion(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/impl/SdkVersionUtil", "detectJdkVersion"));
        }
        return JdkVersionDetector.getInstance().detectJdkVersion(homePath, ACTION_RUNNER);
    }

    @Nullable
    public static JdkVersionDetector.JdkVersionInfo getJdkVersionInfo(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/openapi/projectRoots/impl/SdkVersionUtil", "getJdkVersionInfo"));
        }
        return JdkVersionDetector.getInstance().detectJdkVersionInfo(homePath, ACTION_RUNNER);
    }
}

