/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.JFrame;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DimensionService", storages={@Storage(value="dimensions.xml", roamingType=RoamingType.DISABLED), @Storage(value="options.xml", deprecated=true)})
public class DimensionService
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(DimensionService.class);
    private final Map<String, Point> myKey2Location = new LinkedHashMap();
    private final Map<String, Dimension> myKey2Size = new LinkedHashMap();
    private final TObjectIntHashMap<String> myKey2ExtendedState = new TObjectIntHashMap();
    @NonNls
    private static final String EXTENDED_STATE = "extendedState";
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String STATE = "state";
    @NonNls
    private static final String ELEMENT_LOCATION = "location";
    @NonNls
    private static final String ELEMENT_SIZE = "size";
    @NonNls
    private static final String ATTRIBUTE_X = "x";
    @NonNls
    private static final String ATTRIBUTE_Y = "y";
    @NonNls
    private static final String ATTRIBUTE_WIDTH = "width";
    @NonNls
    private static final String ATTRIBUTE_HEIGHT = "height";

    public static DimensionService getInstance() {
        return ServiceManager.getService(DimensionService.class);
    }

    private DimensionService() {
    }

    @Nullable
    public synchronized Point getLocation(String key) {
        return this.getLocation(key, DimensionService.guessProject());
    }

    @Nullable
    public synchronized Point getLocation(@NotNull String key, Project project) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/DimensionService", "getLocation"));
        }
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        Point point = this.myKey2Location.get(pair.first);
        if (point != null) {
            point = (Point)point.clone();
            float scale = ((Float)pair.second).floatValue();
            point.setLocation((float)point.x / scale, (float)point.y / scale);
        }
        if (point != null && !ScreenUtil.getScreenRectangle(point).contains(point)) {
            point = null;
        }
        return point;
    }

    public synchronized void setLocation(String key, Point point) {
        this.setLocation(key, point, DimensionService.guessProject());
    }

    public synchronized void setLocation(@NotNull String key, Point point, Project project) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/DimensionService", "setLocation"));
        }
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        if (point != null) {
            point = (Point)point.clone();
            float scale = ((Float)pair.second).floatValue();
            point.setLocation((float)point.x * scale, (float)point.y * scale);
            this.myKey2Location.put((String)pair.first, point);
        } else {
            this.myKey2Location.remove(key);
        }
    }

    @Nullable
    public synchronized Dimension getSize(@NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/DimensionService", "getSize"));
        }
        return this.getSize(key, DimensionService.guessProject());
    }

    @Nullable
    public synchronized Dimension getSize(@NotNull @NonNls String key, Project project) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/DimensionService", "getSize"));
        }
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        Dimension size = this.myKey2Size.get(pair.first);
        if (size != null) {
            size = (Dimension)size.clone();
            float scale = ((Float)pair.second).floatValue();
            size.setSize((float)size.width / scale, (float)size.height / scale);
        }
        return size;
    }

    public synchronized void setSize(@NotNull @NonNls String key, Dimension size) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/DimensionService", "setSize"));
        }
        this.setSize(key, size, DimensionService.guessProject());
    }

    public synchronized void setSize(@NotNull @NonNls String key, Dimension size, Project project) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY, "com/intellij/openapi/util/DimensionService", "setSize"));
        }
        Pair<String, Float> pair = DimensionService.keyPair(key, project);
        if (size != null) {
            size = (Dimension)size.clone();
            float scale = ((Float)pair.second).floatValue();
            size.setSize((float)size.width * scale, (float)size.height * scale);
            this.myKey2Size.put((String)pair.first, size);
        } else {
            this.myKey2Size.remove(key);
        }
    }

    @Override
    public Element getState() {
        Element e;
        Element element = new Element(STATE);
        for (String key : this.myKey2Location.keySet()) {
            Point point = this.myKey2Location.get(key);
            LOG.assertTrue(point != null);
            e = new Element(ELEMENT_LOCATION);
            e.setAttribute(KEY, key);
            e.setAttribute(ATTRIBUTE_X, String.valueOf(point.x));
            e.setAttribute(ATTRIBUTE_Y, String.valueOf(point.y));
            element.addContent(e);
        }
        for (String key : this.myKey2Size.keySet()) {
            Dimension size = this.myKey2Size.get(key);
            LOG.assertTrue(size != null);
            e = new Element(ELEMENT_SIZE);
            e.setAttribute(KEY, key);
            e.setAttribute(ATTRIBUTE_WIDTH, String.valueOf(size.width));
            e.setAttribute(ATTRIBUTE_HEIGHT, String.valueOf(size.height));
            element.addContent(e);
        }
        for (Object stateKey : this.myKey2ExtendedState.keys()) {
            String key = (String)stateKey;
            Element e2 = new Element(EXTENDED_STATE);
            e2.setAttribute(KEY, key);
            e2.setAttribute(STATE, String.valueOf(this.myKey2ExtendedState.get((Object)key)));
            element.addContent(e2);
        }
        return element;
    }

    @Override
    public void loadState(Element element) {
        this.myKey2Location.clear();
        this.myKey2Size.clear();
        this.myKey2ExtendedState.clear();
        for (Element e : element.getChildren()) {
            if (ELEMENT_LOCATION.equals(e.getName())) {
                try {
                    this.myKey2Location.put(e.getAttributeValue(KEY), new Point(Integer.parseInt(e.getAttributeValue(ATTRIBUTE_X)), Integer.parseInt(e.getAttributeValue(ATTRIBUTE_Y))));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (ELEMENT_SIZE.equals(e.getName())) {
                try {
                    this.myKey2Size.put(e.getAttributeValue(KEY), new Dimension(Integer.parseInt(e.getAttributeValue(ATTRIBUTE_WIDTH)), Integer.parseInt(e.getAttributeValue(ATTRIBUTE_HEIGHT))));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!EXTENDED_STATE.equals(e.getName())) continue;
            try {
                this.myKey2ExtendedState.put((Object)e.getAttributeValue(KEY), Integer.parseInt(e.getAttributeValue(STATE)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Deprecated
    public void setExtendedState(String key, int extendedState) {
        this.myKey2ExtendedState.put((Object)key, extendedState);
    }

    @Deprecated
    public int getExtendedState(String key) {
        if (!this.myKey2ExtendedState.containsKey((Object)key)) {
            return -1;
        }
        return this.myKey2ExtendedState.get((Object)key);
    }

    @Nullable
    private static Project guessProject() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        return openProjects.length == 1 ? openProjects[0] : null;
    }

    @NotNull
    private static Pair<String, Float> keyPair(String key, @Nullable Project project) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (env.isHeadlessInstance()) {
            Pair pair = new Pair((Object)(key + ".headless"), (Object)Float.valueOf(1.0f));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/DimensionService", "keyPair"));
            }
            return pair;
        }
        JFrame frame = null;
        Component owner = IdeFocusManager.findInstance().getFocusOwner();
        if (owner != null) {
            frame = (JFrame)UIUtil.getParentOfType(JFrame.class, (Component)owner);
        }
        if (frame == null) {
            frame = WindowManager.getInstance().findVisibleFrame();
        }
        if (project != null && (frame == null || frame instanceof IdeFrame && project != ((IdeFrame)((Object)frame)).getProject())) {
            frame = WindowManager.getInstance().getFrame(project);
        }
        Rectangle screen = new Rectangle(0, 0, 0, 0);
        GraphicsDevice gd = null;
        if (frame != null) {
            Point topLeft = frame.getLocation();
            Point2D.Float center = new Point2D.Float(topLeft.x + frame.getWidth() / 2, topLeft.y + frame.getHeight() / 2);
            for (GraphicsDevice device : env.getScreenDevices()) {
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                if (!bounds.contains(center)) continue;
                screen = bounds;
                gd = device;
                break;
            }
        }
        if (gd == null) {
            gd = env.getDefaultScreenDevice();
            screen = gd.getDefaultConfiguration().getBounds();
        }
        float scale = 1.0f;
        if (UIUtil.isJreHiDPIEnabled()) {
            scale = JBUI.sysScale((GraphicsConfiguration)gd.getDefaultConfiguration());
            screen.setBounds((int)Math.floor((float)screen.x * scale), (int)Math.floor((float)screen.y * scale), (int)Math.ceil((float)screen.width * scale), (int)Math.ceil((float)screen.height * scale));
        }
        String realKey = key + '.' + screen.x + '.' + screen.y + '.' + screen.width + '.' + screen.height;
        if (JBUI.isPixHiDPI((GraphicsConfiguration)gd.getDefaultConfiguration())) {
            int dpi = (int)(96.0f * JBUI.pixScale((GraphicsConfiguration)gd.getDefaultConfiguration()));
            realKey = realKey + "@" + dpi + "dpi";
        }
        Pair pair = new Pair((Object)realKey, (Object)Float.valueOf(scale));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/DimensionService", "keyPair"));
        }
        return pair;
    }
}

