/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.versionBrowser;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.DateFilterComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class StandardVersionFilterComponent<T extends ChangeBrowserSettings>
implements ChangesBrowserSettingsEditor<T> {
    private JPanel myPanel;
    private JTextField myNumBefore;
    private JCheckBox myUseNumBeforeFilter;
    private JCheckBox myUseNumAfterFilter;
    private JTextField myNumAfter;
    private DateFilterComponent myDateFilterComponent;
    private JPanel myVersionNumberPanel;
    private T mySettings;

    protected JPanel getDatePanel() {
        return this.myDateFilterComponent.getPanel();
    }

    protected Component getStandardPanel() {
        return this.myPanel;
    }

    public StandardVersionFilterComponent() {
        this.$$$setupUI$$$();
    }

    public StandardVersionFilterComponent(boolean showDateFilter) {
        this.$$$setupUI$$$();
        this.myDateFilterComponent.getPanel().setVisible(showDateFilter);
    }

    protected void init(T settings) {
        this.myVersionNumberPanel.setBorder(IdeBorderFactory.createTitledBorder(this.getChangeNumberTitle(), true));
        this.installCheckBoxesListeners();
        this.initValues(settings);
        this.updateAllEnabled(null);
    }

    protected void disableVersionNumbers() {
        this.myNumAfter.setVisible(false);
        this.myNumBefore.setVisible(false);
        this.myUseNumBeforeFilter.setVisible(false);
        this.myUseNumAfterFilter.setVisible(false);
    }

    protected String getChangeNumberTitle() {
        return VcsBundle.message("border.changes.filter.change.number.filter", new Object[0]);
    }

    private void installCheckBoxesListeners() {
        ActionListener filterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardVersionFilterComponent.this.updateAllEnabled(e);
            }
        };
        this.installCheckBoxListener(filterListener);
    }

    public static void updatePair(JCheckBox checkBox, JComponent textField, ActionEvent e) {
        Object source;
        textField.setEnabled(checkBox.isSelected());
        if (e != null && e.getSource() instanceof JCheckBox && ((JCheckBox)e.getSource()).isSelected() && (source = e.getSource()) == checkBox && checkBox.isSelected()) {
            textField.requestFocus();
        }
    }

    protected void updateAllEnabled(ActionEvent e) {
        StandardVersionFilterComponent.updatePair(this.myUseNumBeforeFilter, this.myNumBefore, e);
        StandardVersionFilterComponent.updatePair(this.myUseNumAfterFilter, this.myNumAfter, e);
    }

    protected void initValues(T settings) {
        this.myUseNumBeforeFilter.setSelected(((ChangeBrowserSettings)settings).USE_CHANGE_BEFORE_FILTER);
        this.myUseNumAfterFilter.setSelected(((ChangeBrowserSettings)settings).USE_CHANGE_AFTER_FILTER);
        this.myDateFilterComponent.initValues((ChangeBrowserSettings)settings);
        this.myNumBefore.setText(((ChangeBrowserSettings)settings).CHANGE_BEFORE);
        this.myNumAfter.setText(((ChangeBrowserSettings)settings).CHANGE_AFTER);
    }

    public void saveValues(T settings) {
        this.myDateFilterComponent.saveValues((ChangeBrowserSettings)settings);
        ((ChangeBrowserSettings)settings).USE_CHANGE_BEFORE_FILTER = this.myUseNumBeforeFilter.isSelected();
        ((ChangeBrowserSettings)settings).USE_CHANGE_AFTER_FILTER = this.myUseNumAfterFilter.isSelected();
        ((ChangeBrowserSettings)settings).CHANGE_BEFORE = this.myNumBefore.getText();
        ((ChangeBrowserSettings)settings).CHANGE_AFTER = this.myNumAfter.getText();
    }

    protected void installCheckBoxListener(ActionListener filterListener) {
        this.myUseNumBeforeFilter.addActionListener(filterListener);
        this.myUseNumAfterFilter.addActionListener(filterListener);
    }

    @Override
    public T getSettings() {
        this.saveValues(this.mySettings);
        return this.mySettings;
    }

    @Override
    public void setSettings(T settings) {
        this.mySettings = settings;
        this.initValues(settings);
        this.updateAllEnabled(null);
    }

    @Override
    public String validateInput() {
        if (this.myUseNumAfterFilter.isSelected()) {
            try {
                Long.parseLong(this.myNumAfter.getText());
            }
            catch (NumberFormatException ex) {
                return this.getChangeNumberTitle() + " From must be a valid number";
            }
        }
        if (this.myUseNumBeforeFilter.isSelected()) {
            try {
                Long.parseLong(this.myNumBefore.getText());
            }
            catch (NumberFormatException ex) {
                return this.getChangeNumberTitle() + " To must be a valid number";
            }
        }
        return this.myDateFilterComponent.validateInput();
    }

    @Override
    public void updateEnabledControls() {
        this.updateAllEnabled(null);
    }

    @Override
    public String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        DateFilterComponent dateFilterComponent;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myVersionNumberPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseNumAfterFilter = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/VcsBundle").getString("checkbox.show.changes.after.num"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNumAfter = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), null));
        this.myUseNumBeforeFilter = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/VcsBundle").getString("checkbox.show.changes.before.num"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNumBefore = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), null));
        this.myDateFilterComponent = dateFilterComponent = new DateFilterComponent();
        JComponent jComponent = dateFilterComponent.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

