/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVcsVirtualFile
extends VirtualFile {
    protected final String myName;
    protected final String myPath;
    protected String myRevision;
    private final VirtualFile myParent;
    protected int myModificationStamp = 0;
    private final VirtualFileSystem myFileSystem;
    protected boolean myProcessingBeforeContentsChange;

    protected AbstractVcsVirtualFile(String path2, VirtualFileSystem fileSystem) {
        this.myFileSystem = fileSystem;
        this.myPath = path2;
        File file = new File(this.myPath);
        this.myName = file.getName();
        this.myParent = !this.isDirectory() ? new VcsVirtualFolder(file.getParent(), this, this.myFileSystem) : null;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFileSystem;
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile", "getPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile", "getName"));
        }
        return string;
    }

    @Override
    public String getPresentableName() {
        if (this.myRevision == null) {
            return this.myName;
        }
        return this.myName + " (" + this.myRevision + ")";
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Override
    public VirtualFile[] getChildren() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.contentsToByteArray(), this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new RuntimeException(VcsFileSystem.COULD_NOT_IMPLEMENT_MESSAGE);
    }

    @Override
    @NotNull
    public abstract byte[] contentsToByteArray() throws IOException;

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public long getTimeStamp() {
        return this.myModificationStamp;
    }

    @Override
    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (postRunnable != null) {
            postRunnable.run();
        }
    }

    protected void setRevision(String revision) {
        this.myRevision = revision;
    }

    protected void fireBeforeContentsChange() {
        this.myProcessingBeforeContentsChange = true;
        try {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ((VcsFileSystem)AbstractVcsVirtualFile.this.getFileSystem()).fireBeforeContentsChange(this, AbstractVcsVirtualFile.this);
                }
            });
        }
        finally {
            this.myProcessingBeforeContentsChange = false;
        }
    }
}

