/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SingleTargetRequestResultProcessor
extends RequestResultProcessor {
    private static final PsiReferenceService ourReferenceService = PsiReferenceService.getService();
    private final PsiElement myTarget;

    public SingleTargetRequestResultProcessor(@NotNull PsiElement target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/psi/search/SingleTargetRequestResultProcessor", "<init>"));
        }
        super(target);
        this.myTarget = target;
    }

    @Override
    public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<PsiReference> consumer) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/SingleTargetRequestResultProcessor", "processTextOccurrence"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/search/SingleTargetRequestResultProcessor", "processTextOccurrence"));
        }
        if (!this.myTarget.isValid()) {
            return false;
        }
        List<PsiReference> references = ourReferenceService.getReferences(element, new PsiReferenceService.Hints(this.myTarget, offsetInElement));
        for (int i2 = 0; i2 < references.size(); ++i2) {
            PsiReference ref = references.get(i2);
            ProgressManager.checkCanceled();
            if (!ReferenceRange.containsOffsetInElement(ref, offsetInElement) || !ref.isReferenceTo(this.myTarget) || consumer.process((Object)ref)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SingleTarget: " + this.myTarget;
    }
}

