/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class Processors {
    @NotNull
    public static <T> Processor<T> cancelableCollectProcessor(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/Processors", "cancelableCollectProcessor"));
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor<T>(collection){

            public boolean process(T t) {
                ProgressManager.checkCanceled();
                return super.process(t);
            }
        };
        if (collectProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Processors", "cancelableCollectProcessor"));
        }
        return collectProcessor;
    }
}

