/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleHelper {
    public static Module[] getModules(Project project) {
        return ModuleManager.getInstance(project).getModules();
    }

    public static boolean dependencyExists(@NotNull ModuleRootManager rootManager, @NotNull Library library) {
        OrderEntry[] orderEntries;
        if (rootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootManager", "com/intellij/webcore/ModuleHelper", "dependencyExists"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/ModuleHelper", "dependencyExists"));
        }
        for (OrderEntry orderEntry : orderEntries = rootManager.getOrderEntries()) {
            LibraryOrderEntry libraryOrderEntry;
            Library moduleLibrary;
            if (!(orderEntry instanceof LibraryOrderEntry) || (moduleLibrary = (libraryOrderEntry = (LibraryOrderEntry)orderEntry).getLibrary()) == null || !moduleLibrary.equals(library) || !moduleLibrary.getTable().getTableLevel().equals(library.getTable().getTableLevel())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuitableModule(@NotNull ScriptingLibraryModel libModel, @NotNull Module module, int moduleCount, @Nullable VirtualFile file) {
        if (libModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libModel", "com/intellij/webcore/ModuleHelper", "isSuitableModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/webcore/ModuleHelper", "isSuitableModule"));
        }
        if (file != null) {
            return module.getModuleContentScope().contains(file);
        }
        if (moduleCount == 1) {
            return true;
        }
        if (libModel.hasAssociatedModules()) {
            return libModel.isAssociatedWith(module);
        }
        return "WEB_MODULE".equals(module.getOptionValue("type"));
    }

    public static void removeDependencies(@NotNull Project project, @NotNull Library library) {
        Module[] modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/ModuleHelper", "removeDependencies"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/ModuleHelper", "removeDependencies"));
        }
        for (Module module : modules = ModuleManager.getInstance(project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
            if (!ModuleHelper.dependencyExists(rootManager, library)) continue;
            ModuleHelper.removeDependency(rootManager, library);
        }
    }

    public static void removeDependency(@NotNull ModuleRootManager rootManager, @NotNull Library library) {
        if (rootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootManager", "com/intellij/webcore/ModuleHelper", "removeDependency"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/ModuleHelper", "removeDependency"));
        }
        ModifiableRootModel model = rootManager.getModifiableModel();
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)orderEntry).getLibrary() != library) continue;
            model.removeOrderEntry(orderEntry);
        }
        model.commit();
    }

    public static Set<Module> getAssociatedModules(Project project, Library library) {
        Module[] modules;
        HashSet associatedModules = new HashSet();
        for (Module module : modules = ModuleManager.getInstance(project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
            if (!ModuleHelper.dependencyExists(rootManager, library)) continue;
            associatedModules.add(module);
        }
        return associatedModules;
    }
}

