/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.ScriptingLibraryProperties;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptingLibraryManager {
    private final Project myProject;
    private final PersistentLibraryKind myLibraryKind;
    private volatile ScriptingLibraryTable myLibTable;
    private final Object myLock;

    protected ScriptingLibraryManager(@NotNull Project project, @NotNull PersistentLibraryKind libraryKind) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ScriptingLibraryManager", "<init>"));
        }
        if (libraryKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryKind", "com/intellij/webcore/libraries/ScriptingLibraryManager", "<init>"));
        }
        this.myLock = new Object();
        this.myProject = project;
        this.myLibraryKind = libraryKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ScriptingLibraryTable getScriptingLibraryTable() {
        ScriptingLibraryTable libraryTable = this.myLibTable;
        if (libraryTable == null) {
            Object object = this.myLock;
            synchronized (object) {
                libraryTable = this.myLibTable;
                if (libraryTable == null) {
                    this.myLibTable = libraryTable = this.readLibraryTable();
                }
            }
        }
        ScriptingLibraryTable scriptingLibraryTable = libraryTable;
        if (scriptingLibraryTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getScriptingLibraryTable"));
        }
        return scriptingLibraryTable;
    }

    @NotNull
    private ScriptingLibraryTable readLibraryTable() {
        ScriptingLibraryTable scriptingLibraryTable = ApplicationManager.getApplication().runReadAction(new Computable<ScriptingLibraryTable>(){

            public ScriptingLibraryTable compute() {
                ScriptingLibraryTable libraryTable = new ScriptingLibraryTable(ScriptingLibraryManager.this.myLibraryKind, ScriptingLibraryManager.this.myProject);
                libraryTable.readFrom(ScriptingLibraryManager.this.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL));
                libraryTable.readFrom(ScriptingLibraryManager.this.getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT));
                ScriptingLibraryManager.this.initPredefinedLibraries(libraryTable);
                return libraryTable;
            }
        });
        if (scriptingLibraryTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "readLibraryTable"));
        }
        return scriptingLibraryTable;
    }

    public void commitChanges() {
        if (this.myLibTable != null) {
            this.updateLibraries(ScriptingLibraryModel.LibraryLevel.GLOBAL);
            this.updateLibraries(ScriptingLibraryModel.LibraryLevel.PROJECT);
            this.myLibTable = null;
        }
        this.getLibraryMappings().updateMappings();
        ProjectRootManagerEx.getInstanceEx(this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true);
    }

    private void updateLibraries(@NotNull ScriptingLibraryModel.LibraryLevel libraryLevel) {
        if (libraryLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryLevel", "com/intellij/webcore/libraries/ScriptingLibraryManager", "updateLibraries"));
        }
        LibraryTable libTable = this.getLibraryTable(libraryLevel);
        ScriptingLibraryTable scriptingLibTable = this.getScriptingLibraryTable();
        LibraryTable.ModifiableModel libTableModel = libTable.getModifiableModel();
        for (Library library : libTableModel.getLibraries()) {
            if (!(library instanceof LibraryEx)) continue;
            PersistentLibraryKind<?> libKind = ((LibraryEx)library).getKind();
            String libraryName = library.getName();
            if (libKind != this.myLibraryKind || libraryName == null) continue;
            ScriptingLibraryModel scriptingLibModel = scriptingLibTable.getModel(library);
            if (scriptingLibModel == null) {
                this.removeLibraryAndDependencies(libTableModel, library);
                continue;
            }
            if (scriptingLibModel.getLibraryLevel() != libraryLevel) {
                scriptingLibModel.setOriginalLibrary(null);
                this.removeLibraryAndDependencies(libTableModel, library);
                continue;
            }
            Library.ModifiableModel libModel = library.getModifiableModel();
            libModel.setName(scriptingLibModel.getName());
            ScriptingLibraryManager.copyRoots(scriptingLibModel, libModel);
            libModel.commit();
            this.updateModuleDependencies(scriptingLibModel);
        }
        for (ScriptingLibraryModel scriptingLibModel : scriptingLibTable.getLibraries(libraryLevel)) {
            Library library = scriptingLibModel.getOriginalLibrary();
            if (library == null) {
                library = libTableModel.createLibrary(scriptingLibModel.getName(), this.myLibraryKind);
                scriptingLibModel.setOriginalLibrary(library);
                Library.ModifiableModel platformLibModel = library.getModifiableModel();
                ScriptingLibraryManager.copyRoots(scriptingLibModel, platformLibModel);
                platformLibModel.commit();
            }
            this.updateModuleDependencies(scriptingLibModel);
        }
        libTableModel.commit();
    }

    private static void copyRoots(ScriptingLibraryModel source, Library.ModifiableModel target) {
        for (VirtualFile libRoot : target.getFiles(OrderRootType.SOURCES)) {
            target.removeRoot(libRoot.getUrl(), OrderRootType.SOURCES);
        }
        for (VirtualFile libRoot : target.getFiles(OrderRootType.CLASSES)) {
            target.removeRoot(libRoot.getUrl(), OrderRootType.CLASSES);
        }
        for (VirtualFile newRoot : source.getAllFiles()) {
            target.addRoot(newRoot, OrderRootType.CLASSES);
        }
        for (String docUrl : target.getUrls(OrderRootType.DOCUMENTATION)) {
            target.removeRoot(docUrl, OrderRootType.DOCUMENTATION);
        }
        for (String docUrl : source.getDocUrls()) {
            target.addRoot(docUrl, OrderRootType.DOCUMENTATION);
        }
        if (target instanceof LibraryEx.ModifiableModelEx) {
            List urls = ContainerUtil.map(source.getSourceFiles(), VirtualFile::getUrl);
            ((LibraryEx.ModifiableModelEx)target).setProperties(new ScriptingLibraryProperties(source.getFrameworkDescriptor(), urls));
        }
    }

    private void removeLibraryAndDependencies(@NotNull LibraryTable.ModifiableModel table, @NotNull Library library) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/webcore/libraries/ScriptingLibraryManager", "removeLibraryAndDependencies"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/libraries/ScriptingLibraryManager", "removeLibraryAndDependencies"));
        }
        ModuleHelper.removeDependencies(this.getProject(), library);
        table.removeLibrary(library);
    }

    private void updateModuleDependencies(@NotNull ScriptingLibraryModel libraryModel) {
        if (libraryModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryModel", "com/intellij/webcore/libraries/ScriptingLibraryManager", "updateModuleDependencies"));
        }
        Library originalLibrary = libraryModel.getOriginalLibrary();
        if (originalLibrary == null) {
            return;
        }
        Module[] modules = ModuleManager.getInstance(this.getProject()).getModules();
        ScriptingLibraryMappings mappings = this.getLibraryMappings();
        for (Module module : modules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
            boolean hasDependency = ModuleHelper.dependencyExists(rootManager, originalLibrary);
            if (mappings.dependsOn(module, libraryModel, modules.length)) {
                if (hasDependency) continue;
                ModuleRootModificationUtil.addDependency(module, originalLibrary);
                continue;
            }
            if (!hasDependency) continue;
            ModuleHelper.removeDependency(rootManager, originalLibrary);
        }
    }

    public void reset() {
        this.myLibTable = null;
    }

    public void clearCaches() {
        if (this.myLibTable != null) {
            this.myLibTable.invalidateCache();
        }
    }

    @NotNull
    public ScriptingLibraryModel createLibrary(String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls, ScriptingLibraryModel.LibraryLevel level, boolean isOnByDefault) {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        ScriptingLibraryModel scriptingLibraryModel = libraryTable.createLibrary(name, sourceFiles, compactFiles, docUrls, level, isOnByDefault);
        if (scriptingLibraryModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "createLibrary"));
        }
        return scriptingLibraryModel;
    }

    public void removeLibrary(ScriptingLibraryModel library) {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        libraryTable.removeLibrary(library);
    }

    @Nullable
    public ScriptingLibraryModel updateLibrary(String oldName, String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls) {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        ScriptingLibraryModel libModel = libraryTable.getLibraryByName(oldName);
        if (libModel != null) {
            libModel.setName(name);
            libModel.setSourceFiles(sourceFiles);
            libModel.setCompactFiles(compactFiles);
            libModel.setDocUrls(docUrls);
            libraryTable.renameLibrary(oldName, name);
            libraryTable.invalidateCache();
            return libModel;
        }
        return null;
    }

    @NotNull
    public ScriptingLibraryModel[] getLibraries(ScriptingLibraryModel.LibraryLevel libraryLevel) {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        ScriptingLibraryModel[] scriptingLibraryModelArray = libraryTable.getLibraries(libraryLevel);
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getLibraries"));
        }
        return scriptingLibraryModelArray;
    }

    @Nullable
    public ScriptingLibraryModel getLibraryByName(String name) {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        return libraryTable.getLibraryByName(name);
    }

    @NotNull
    public LibraryTable getLibraryTable(ScriptingLibraryModel.LibraryLevel libraryLevel) {
        LibraryTable libraryTable = ScriptingLibraryManager.getLibraryTable(this.myProject, libraryLevel);
        if (libraryTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getLibraryTable"));
        }
        return libraryTable;
    }

    @NotNull
    private static LibraryTable getLibraryTable(Project project, @NotNull ScriptingLibraryModel.LibraryLevel libraryLevel) {
        if (libraryLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryLevel", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getLibraryTable"));
        }
        if (libraryLevel == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
            if (libraryTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getLibraryTable"));
            }
            return libraryTable;
        }
        if (libraryLevel == ScriptingLibraryModel.LibraryLevel.PROJECT) {
            LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
            if (libraryTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getLibraryTable"));
            }
            return libraryTable;
        }
        throw new RuntimeException("Unexpected libraryLevel: " + (Object)((Object)libraryLevel));
    }

    private static void collectLibraryFiles(@NotNull Collection<VirtualFile> collectedFiles, Project project, LibraryKind libraryKind, ScriptingLibraryModel.LibraryLevel level) {
        if (collectedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectedFiles", "com/intellij/webcore/libraries/ScriptingLibraryManager", "collectLibraryFiles"));
        }
        LibraryTable libraryTable = ScriptingLibraryManager.getLibraryTable(project, level);
        for (Library library : libraryTable.getLibraries()) {
            LibraryEx libraryEx;
            if (!(library instanceof LibraryEx) || (libraryEx = (LibraryEx)library).isDisposed() || libraryEx.getKind() != libraryKind) continue;
            collectedFiles.addAll(Arrays.asList(libraryEx.getFiles(OrderRootType.SOURCES)));
            collectedFiles.addAll(Arrays.asList(libraryEx.getFiles(OrderRootType.CLASSES)));
        }
    }

    public static Set<VirtualFile> getAllLibraryFiles(final Project project, final LibraryKind libraryKind) {
        return ApplicationManager.getApplication().runReadAction(new Computable<Set<VirtualFile>>(){

            public Set<VirtualFile> compute() {
                HashSet collectedFiles = new HashSet();
                ScriptingLibraryManager.collectLibraryFiles((Collection)collectedFiles, project, libraryKind, ScriptingLibraryModel.LibraryLevel.GLOBAL);
                ScriptingLibraryManager.collectLibraryFiles((Collection)collectedFiles, project, libraryKind, ScriptingLibraryModel.LibraryLevel.PROJECT);
                return collectedFiles;
            }
        });
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getProject"));
        }
        return project;
    }

    public ThreeState getFileState(VirtualFile file) {
        return this.getScriptingLibraryTable().getFileState(file);
    }

    @Nullable
    public VirtualFile getMatchingFile(String fileName) {
        return this.getScriptingLibraryTable().findProjectOrGlobalLibraryFileByName(fileName);
    }

    public boolean isLibraryFile(VirtualFile file) {
        return this.getFileState(file) != ThreeState.UNSURE;
    }

    @NotNull
    public Set<String> getDocUrlsFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getDocUrlsFor"));
        }
        Set<String> set = this.getScriptingLibraryTable().getDocUrlsFor(file);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getDocUrlsFor"));
        }
        return set;
    }

    protected abstract void initPredefinedLibraries(@NotNull ScriptingLibraryTable var1);

    @NotNull
    public Set<VirtualFile> getPredefinedLibraryFiles() {
        HashSet predefinedFiles = new HashSet();
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        for (ScriptingLibraryModel libModel : libraryTable.getLibraries(ScriptingLibraryModel.LibraryLevel.PREDEFINED)) {
            predefinedFiles.addAll(libModel.getSourceFiles());
        }
        HashSet hashSet = predefinedFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getPredefinedLibraryFiles"));
        }
        return hashSet;
    }

    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries() {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        ScriptingLibraryModel[] scriptingLibraryModelArray = libraryTable.getLibraries(ScriptingLibraryModel.LibraryLevel.PREDEFINED);
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getPredefinedLibraries"));
        }
        return scriptingLibraryModelArray;
    }

    @NotNull
    public ScriptingLibraryModel[] getAllLibraries() {
        ScriptingLibraryTable libraryTable = this.getScriptingLibraryTable();
        ScriptingLibraryModel[] scriptingLibraryModelArray = libraryTable.getAllLibraries();
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getAllLibraries"));
        }
        return scriptingLibraryModelArray;
    }

    @NotNull
    static ScriptingLibraryModel.LibraryLevel getLibraryLevel(LibraryTable libraryTable) {
        if (libraryTable.getTableLevel() == "project") {
            ScriptingLibraryModel.LibraryLevel libraryLevel = ScriptingLibraryModel.LibraryLevel.PROJECT;
            if (libraryLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getLibraryLevel"));
            }
            return libraryLevel;
        }
        if (libraryTable.getTableLevel() == "application") {
            ScriptingLibraryModel.LibraryLevel libraryLevel = ScriptingLibraryModel.LibraryLevel.GLOBAL;
            if (libraryLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryManager", "getLibraryLevel"));
            }
            return libraryLevel;
        }
        throw new RuntimeException("Unexpected library table: " + libraryTable.getTableLevel());
    }

    @NotNull
    public abstract ScriptingLibraryMappings getLibraryMappings();

    public void associateWithProject(String libraryName) {
        ScriptingLibraryTable libTable = this.getScriptingLibraryTable();
        assert (libTable.getLibraryByName(libraryName) != null) : "Library '" + libraryName + "' not found";
        ScriptingLibraryMappings mappings = this.getLibraryMappings();
        mappings.associateWithProject(libraryName);
    }

    @Nullable
    public ScriptingLibraryModel findLibrary(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ScriptingLibraryManager", "findLibrary"));
        }
        return this.getScriptingLibraryTable().findLibrary(file);
    }
}

