/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class DonePromise<T>
implements Getter<T>,
Promise<T> {
    private final T result;

    public DonePromise(T result) {
        this.result = result;
    }

    @Override
    @NotNull
    public Promise<T> done(@NotNull Consumer<? super T> done2) {
        if (done2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/DonePromise", "done"));
        }
        if (!AsyncPromiseKt.isObsolete(done2)) {
            done2.consume(this.result);
        }
        DonePromise donePromise = this;
        if (donePromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "done"));
        }
        return donePromise;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull AsyncPromise<? super T> fulfilled) {
        if (fulfilled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fulfilled", "org/jetbrains/concurrency/DonePromise", "processed"));
        }
        fulfilled.setResult(this.result);
        DonePromise donePromise = this;
        if (donePromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "processed"));
        }
        return donePromise;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Consumer<? super T> processed2) {
        if (processed2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "org/jetbrains/concurrency/DonePromise", "processed"));
        }
        this.done(processed2);
        DonePromise donePromise = this;
        if (donePromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "processed"));
        }
        return donePromise;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected2) {
        if (rejected2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rejected", "org/jetbrains/concurrency/DonePromise", "rejected"));
        }
        DonePromise donePromise = this;
        if (donePromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "rejected"));
        }
        return donePromise;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done2) {
        if (done2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/DonePromise", "then"));
        }
        if (done2 instanceof Obsolescent && ((Obsolescent)done2).isObsolete()) {
            Promise promise = Promises.rejectedPromise("obsolete");
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "then"));
            }
            return promise;
        }
        Promise<Object> promise = Promises.resolvedPromise(done2.fun(this.result));
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "then"));
        }
        return promise;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> done2) {
        if (done2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/DonePromise", "thenAsync"));
        }
        Promise promise = (Promise)done2.fun(this.result);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "thenAsync"));
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise.State getState() {
        Promise.State state = Promise.State.FULFILLED;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/DonePromise", "getState"));
        }
        return state;
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "org/jetbrains/concurrency/DonePromise", "blockingGet"));
        }
        return this.result;
    }

    public T get() {
        return this.result;
    }

    @Override
    public void notify(@NotNull AsyncPromise<? super T> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/concurrency/DonePromise", "notify"));
        }
        child.setResult(this.result);
    }
}

