/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.quirksmode.Browser;
import com.jetbrains.quirksmode.BrowserFamily;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BrowserSet {
    public static final BrowserSet IE = new BrowserSet(BrowserFamily.IE);
    public static final BrowserSet IE_50 = new BrowserSet(Browser.IE_50_WINDOWS);
    public static final BrowserSet IE_55 = new BrowserSet(Browser.IE_55_WINDOWS);
    public static final BrowserSet IE_55_AND_60 = new BrowserSet(Browser.IE_55_WINDOWS).and(Browser.IE_6_WINDOWS);
    public static final BrowserSet IE_LESS_THAN_7 = new BrowserSet(Browser.IE_50_WINDOWS).and(Browser.IE_55_WINDOWS).and(Browser.IE_6_WINDOWS);
    public static final BrowserSet MOZILLA = new BrowserSet(BrowserFamily.MOZILLA);
    public static final BrowserSet SAFARI = new BrowserSet(BrowserFamily.SAFARI);
    private final Set<BrowserFamily> myBrowserFamilies;
    private final Set<Browser> myBrowsers;
    public static final BrowserSet ALL = new BrowserSet(new Browser[0]){

        @Override
        public boolean contains(Browser browser) {
            return true;
        }
    };

    public BrowserSet(Browser ... browsers) {
        this.myBrowserFamilies = new HashSet<BrowserFamily>();
        this.myBrowsers = new HashSet<Browser>();
        ContainerUtil.addAll(this.myBrowsers, (Object[])browsers);
    }

    public BrowserSet(@NotNull BrowserFamily family) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/jetbrains/quirksmode/BrowserSet", "<init>"));
        }
        this.myBrowserFamilies = new HashSet<BrowserFamily>();
        this.myBrowsers = new HashSet<Browser>();
        this.myBrowserFamilies.add(family);
    }

    public BrowserSet(@NotNull Set<BrowserFamily> browserFamilies, @NotNull Set<Browser> browsers) {
        if (browserFamilies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserFamilies", "com/jetbrains/quirksmode/BrowserSet", "<init>"));
        }
        if (browsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browsers", "com/jetbrains/quirksmode/BrowserSet", "<init>"));
        }
        this.myBrowserFamilies = new HashSet<BrowserFamily>();
        this.myBrowsers = new HashSet<Browser>();
        this.myBrowserFamilies.addAll(browserFamilies);
        this.myBrowsers.addAll(browsers);
    }

    public BrowserSet and(@NotNull Browser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/quirksmode/BrowserSet", "and"));
        }
        BrowserSet copy = this.copy();
        copy.add(browser);
        return copy;
    }

    public BrowserSet and(@NotNull BrowserSet browserSet) {
        if (browserSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserSet", "com/jetbrains/quirksmode/BrowserSet", "and"));
        }
        BrowserSet copy = this.copy();
        for (Browser browser : browserSet.myBrowsers) {
            copy.add(browser);
        }
        for (BrowserFamily family : browserSet.myBrowserFamilies) {
            copy.add(family);
        }
        return copy;
    }

    public BrowserSet and(@NotNull BrowserFamily browserFamily) {
        if (browserFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserFamily", "com/jetbrains/quirksmode/BrowserSet", "and"));
        }
        BrowserSet copy = this.copy();
        copy.add(browserFamily);
        return copy;
    }

    private void add(@NotNull BrowserFamily browserFamily) {
        if (browserFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserFamily", "com/jetbrains/quirksmode/BrowserSet", "add"));
        }
        this.myBrowserFamilies.add(browserFamily);
    }

    private void add(@NotNull Browser browser) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/quirksmode/BrowserSet", "add"));
        }
        if (!this.myBrowserFamilies.contains((Object)browser.getFamily())) {
            this.myBrowsers.add(browser);
        }
    }

    private BrowserSet copy() {
        return new BrowserSet(this.myBrowserFamilies, this.myBrowsers);
    }

    public boolean contains(Browser browser) {
        return this.myBrowserFamilies.contains((Object)browser.getFamily()) || this.myBrowsers.contains(browser);
    }

    public String toString() {
        String result = "";
        for (BrowserFamily family : this.myBrowserFamilies) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + family.getName();
        }
        for (Browser browser : this.myBrowsers) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + browser.getName();
        }
        return result;
    }

    public boolean intersects(@NotNull BrowserSet browserSet) {
        if (browserSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserSet", "com/jetbrains/quirksmode/BrowserSet", "intersects"));
        }
        for (Browser browser : this.myBrowsers) {
            if (!browserSet.contains(browser)) continue;
            return true;
        }
        for (BrowserFamily family : this.myBrowserFamilies) {
            if (!browserSet.contains(family)) continue;
            return true;
        }
        for (Browser browser : browserSet.myBrowsers) {
            if (!this.contains(browser)) continue;
            return true;
        }
        for (BrowserFamily family : browserSet.myBrowserFamilies) {
            if (!this.contains(family)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(@NotNull BrowserFamily browserFamily) {
        if (browserFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserFamily", "com/jetbrains/quirksmode/BrowserSet", "contains"));
        }
        return this.myBrowserFamilies.contains((Object)browserFamily);
    }
}

