/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SharedProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.quirksmode.PsiRecursiveVisitor2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssHtmlPatternUtil {
    public static final Key<CssDeclaration[]> COMPUTED_STYLES_KEY = new Key("COMPUTED_STYLES_KEY");
    public static final Key<List<XmlTag>> APPLIED_TAGS_KEY = new Key("APPLIED_TAGS_KEY");

    private CssHtmlPatternUtil() {
    }

    @Nullable
    public static String getStyle(@NotNull PsiElement element, @NotNull @NonNls String propertyName, @NotNull SharedProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/quirksmode/CssHtmlPatternUtil", "getStyle"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/jetbrains/quirksmode/CssHtmlPatternUtil", "getStyle"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/quirksmode/CssHtmlPatternUtil", "getStyle"));
        }
        CssDeclaration[] declarations = CssHtmlPatternUtil.getStyles(element, context);
        if (declarations == null) {
            return null;
        }
        for (CssDeclaration decl : declarations) {
            if (!propertyName.equals(CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)decl))) continue;
            return CssPsiUtil.getTokenText((PsiElement)decl.getValue());
        }
        return null;
    }

    @Nullable
    public static CssDeclaration[] getStyles(@NotNull PsiElement element, @NotNull SharedProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/quirksmode/CssHtmlPatternUtil", "getStyles"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/quirksmode/CssHtmlPatternUtil", "getStyles"));
        }
        return (CssDeclaration[])context.get(COMPUTED_STYLES_KEY, (Object)element);
    }

    @Nullable
    public static XmlTag[] getAppliedTags(@NotNull CssDeclaration declaration, @NotNull SharedProcessingContext context) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/quirksmode/CssHtmlPatternUtil", "getAppliedTags"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/quirksmode/CssHtmlPatternUtil", "getAppliedTags"));
        }
        List list = (List)context.get(APPLIED_TAGS_KEY, (Object)declaration);
        return list == null ? null : list.toArray(new XmlTag[list.size()]);
    }

    public static void buildCaches(@NotNull PsiElement element, final @NotNull SharedProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/quirksmode/CssHtmlPatternUtil", "buildCaches"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/quirksmode/CssHtmlPatternUtil", "buildCaches"));
        }
        new PsiRecursiveVisitor2(){

            public void visitElement(final PsiElement element) {
                new ReadAction(){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/quirksmode/CssHtmlPatternUtil$1$1", "run"));
                        }
                        CssHtmlPatternUtil.cacheStyles(element, context);
                    }
                }.execute();
                CssDeclaration[] declarations = (CssDeclaration[])context.get(COMPUTED_STYLES_KEY, (Object)element);
                if (declarations != null) {
                    for (CssDeclaration decl : declarations) {
                        ArrayList<XmlTag> appliedTags = (ArrayList<XmlTag>)context.get(APPLIED_TAGS_KEY, (Object)decl);
                        if (appliedTags == null) {
                            appliedTags = new ArrayList<XmlTag>();
                            context.put(APPLIED_TAGS_KEY, (Object)decl, appliedTags);
                        }
                        appliedTags.add((XmlTag)element);
                    }
                }
                super.visitElement(element);
            }
        }.accept(element);
    }

    public static void cacheStyles(@Nullable PsiElement element, @NotNull SharedProcessingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/quirksmode/CssHtmlPatternUtil", "cacheStyles"));
        }
        CssDeclaration[] computedStyles = (CssDeclaration[])context.get(COMPUTED_STYLES_KEY, (Object)element);
        if (computedStyles != null) {
            return;
        }
        if (!(element instanceof XmlTag)) {
            return;
        }
        ArrayList<CssDeclaration> decls = new ArrayList<CssDeclaration>();
        Object[] styles = CssResolveManager.getInstance().resolve((XmlTag)element);
        if (styles != null && styles.length != 0) {
            CssDeclaration[] parentDecls;
            ContainerUtil.addAll(decls, (Object[])styles);
            PsiElement parent = element.getParent();
            if (parent != null && (parentDecls = (CssDeclaration[])context.get(COMPUTED_STYLES_KEY, (Object)parent)) != null) {
                for (CssDeclaration parentDecl : parentDecls) {
                    boolean inherited = true;
                    Collection descriptors = parentDecl.getDescriptors();
                    for (CssPropertyDescriptor descriptor : descriptors) {
                        if (descriptor.isInherited()) continue;
                        inherited = false;
                        break;
                    }
                    if (descriptors.isEmpty() || !inherited) continue;
                    decls.add(parentDecl);
                }
            }
        }
        context.put(COMPUTED_STYLES_KEY, (Object)element, (Object)decls.toArray(new CssDeclaration[decls.size()]));
    }
}

