/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public abstract class PsiRecursiveVisitor2
extends PsiElementVisitor {
    private final Set<PsiElement> myChildrenToSkip = new HashSet<PsiElement>();
    private final Set<PsiElement> mySkip = new HashSet<PsiElement>();

    public void accept(PsiElement element) {
        LinkedList<PsiElement> elementsToProcess = new LinkedList<PsiElement>();
        elementsToProcess.add(element);
        while (!elementsToProcess.isEmpty()) {
            PsiElement e = (PsiElement)elementsToProcess.remove(0);
            if (this.mySkip.contains(e)) {
                this.mySkip.remove(e);
                continue;
            }
            e.accept((PsiElementVisitor)this);
            if (this.myChildrenToSkip.contains(e)) {
                this.myChildrenToSkip.remove(e);
                continue;
            }
            PsiElement[] children = e.getChildren();
            for (int i = children.length - 1; i >= 0; --i) {
                PsiElement child = children[i];
                elementsToProcess.add(0, child);
            }
        }
    }

    protected void skipChildren(PsiElement element) {
        this.myChildrenToSkip.add(element);
    }

    protected void skip(PsiElement element) {
        this.mySkip.add(element);
    }
}

