/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.base;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.ui.ScopePanelListener;
import com.sixrr.xrp.ui.XSLTDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseRefactoringDialog
extends DialogWrapper
implements ScopePanelListener {
    private final Action refactorAction = new RefactorAction();
    private final Action previewAction = new PreviewAction();
    private final Action showXLTAction = new ShowXSLTAction();
    private boolean previewResults = false;
    protected ScopePanel scopePanel;
    protected final ValidationDocListener docListener = new ValidationDocListener();
    private final Project project;

    public BaseRefactoringDialog(Project project, boolean b) {
        super(project, b);
        this.project = project;
        this.setModal(true);
    }

    public boolean isPreviewUsages() {
        return this.previewResults;
    }

    protected void doOKAction() {
        this.validateButtons();
        if (!this.isOKActionEnabled()) {
            return;
        }
        this.close(0);
    }

    protected void validateButtons() {
        boolean isValid = this.isValid();
        this.previewAction.setEnabled(isValid);
        this.refactorAction.setEnabled(isValid);
        this.showXLTAction.setEnabled(isValid);
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getHelpAction(), this.getCancelAction(), this.showXLTAction, this.previewAction, this.refactorAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/base/BaseRefactoringDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.refactorAction, this.previewAction, this.showXLTAction, this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/base/BaseRefactoringDialog", "createActions"));
        }
        return actionArray;
    }

    @Override
    public void scopeSelectionHasChanged() {
        this.validateButtons();
    }

    public Context getContext() {
        return this.scopePanel.getContext();
    }

    protected JComponent createCenterPanel() {
        return this.scopePanel;
    }

    protected abstract boolean isValid();

    @NonNls
    protected abstract String getDimensionServiceKey();

    protected abstract void doHelpAction();

    public abstract JComponent getPreferredFocusedComponent();

    @NonNls
    protected abstract String calculateXSLT();

    protected class ValidationDocListener
    implements DocumentListener {
        protected ValidationDocListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            BaseRefactoringDialog.this.validateButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            BaseRefactoringDialog.this.validateButtons();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            BaseRefactoringDialog.this.validateButtons();
        }
    }

    private class ShowXSLTAction
    extends AbstractAction {
        ShowXSLTAction() {
            this.putValue("Name", "Show XSLT...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseRefactoringDialog.this.validateButtons();
            if (!BaseRefactoringDialog.this.isOKActionEnabled()) {
                return;
            }
            String xslt = BaseRefactoringDialog.this.calculateXSLT();
            XSLTDialog dialog = new XSLTDialog(BaseRefactoringDialog.this.project, xslt);
            dialog.show();
        }
    }

    private class PreviewAction
    extends AbstractAction {
        PreviewAction() {
            this.putValue("Name", "Preview");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseRefactoringDialog.this.validateButtons();
            if (!BaseRefactoringDialog.this.isOKActionEnabled()) {
                return;
            }
            BaseRefactoringDialog.this.previewResults = true;
            BaseRefactoringDialog.this.close(0);
        }
    }

    protected class RefactorAction
    extends AbstractAction {
        RefactorAction() {
            this.putValue("Name", "Refactor");
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseRefactoringDialog.this.validateButtons();
            if (!BaseRefactoringDialog.this.isOKActionEnabled()) {
                return;
            }
            BaseRefactoringDialog.this.previewResults = false;
            BaseRefactoringDialog.this.close(0);
        }
    }
}

