/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.moveattributeout;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.moveattributeout.MoveAttributeOut;
import com.sixrr.xrp.moveattributeout.MoveAttributeOutUsageViewDescriptor;
import com.sixrr.xrp.psi.TagSearchVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MoveAttributeOutProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlAttribute attribute;
    private final Context context;

    MoveAttributeOutProcessor(XmlAttribute attribute, Context context) {
        super(attribute.getProject());
        this.attribute = attribute;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/moveattributeout/MoveAttributeOutProcessor", "createUsageViewDescriptor"));
        }
        MoveAttributeOutUsageViewDescriptor moveAttributeOutUsageViewDescriptor = new MoveAttributeOutUsageViewDescriptor(this.attribute, usageInfos);
        if (moveAttributeOutUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/moveattributeout/MoveAttributeOutProcessor", "createUsageViewDescriptor"));
        }
        return moveAttributeOutUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/moveattributeout/MoveAttributeOutProcessor", "findUsages"));
        }
        XmlTag tag = this.attribute.getParent();
        String tagName = tag.getName();
        String attributeName = this.attribute.getName();
        String attributeNamespace = this.attribute.getNamespace();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            usages.add(new MoveAttributeOut(xmlTag, attributeName, attributeNamespace));
        }
    }

    protected String getCommandName() {
        return "Moved attribute " + this.attribute.getName() + " out";
    }
}

