/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.renametag;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.renametag.RenameTag;
import com.sixrr.xrp.renametag.RenameTagUsageViewDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class RenameTagProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String newTagName;
    private final Context context;

    RenameTagProcessor(XmlTag tag, String newTagName, Context context) {
        super(tag.getProject());
        this.tag = tag;
        this.newTagName = newTagName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/renametag/RenameTagProcessor", "createUsageViewDescriptor"));
        }
        RenameTagUsageViewDescriptor renameTagUsageViewDescriptor = new RenameTagUsageViewDescriptor(this.tag, usageInfos);
        if (renameTagUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/renametag/RenameTagProcessor", "createUsageViewDescriptor"));
        }
        return renameTagUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/renametag/RenameTagProcessor", "findUsages"));
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            if (xmlTag == null) continue;
            usages.add(new RenameTag(xmlTag, this.newTagName));
        }
    }

    protected String getCommandName() {
        return "Rename tag " + this.tag.getName();
    }
}

