/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapUtil;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.externalToolsDetector.PhoneGapExecutableChecker;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.PhoneGapSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhoneGapProjectComponent
extends AbstractProjectComponent {
    protected PhoneGapProjectComponent(Project project) {
        super(project);
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (PhoneGapUtil.isPhoneGapProject(this.myProject)) {
                if (PhoneGapSettings.getInstance().isExcludePlatformFolder()) {
                    this.excludePlatformFolders();
                }
                PhoneGapExecutableChecker.check(this.myProject);
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapProjectComponent$1", "fileCreated"));
                }
                if (!this.isProcess(event)) {
                    return;
                }
                PhoneGapProjectComponent.this.updateModuleExcludeByFSEvent(event, ContainerUtil.newHashSet(), ContainerUtil.newHashSet((Iterable)PhoneGapProjectComponent.getExcludedFolderNames(event)));
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapProjectComponent$1", "beforeFileDeletion"));
                }
                if (!this.isProcess(event)) {
                    return;
                }
                PhoneGapProjectComponent.this.updateModuleExcludeByFSEvent(event, PhoneGapProjectComponent.getExcludedFolderNames(event), ContainerUtil.newHashSet());
            }

            private boolean isProcess(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapProjectComponent$1", "isProcess"));
                }
                return event.getFileName().equals("platforms") && event.getFile().isDirectory() && PhoneGapUtil.isPhoneGapProject(PhoneGapProjectComponent.this.myProject) && PhoneGapSettings.getInstance().isExcludePlatformFolder();
            }
        }, (Disposable)this.myProject);
    }

    private static Set<String> getExcludedFolderNames(VirtualFileEvent event) {
        return ContainerUtil.newHashSet((Object[])new String[]{event.getFile().getUrl()});
    }

    private void updateModuleExcludeByFSEvent(VirtualFileEvent event, Set<String> oldToUpdateFolders, Set<String> newToUpdateFolders) {
        VirtualFile eventFile = event.getFile();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)eventFile, (Project)this.myProject);
        if (module == null) {
            return;
        }
        VirtualFile contentRoot = PhoneGapProjectComponent.getContentRoot(module, event.getParent());
        if (contentRoot == null) {
            return;
        }
        ModuleRootModificationUtil.updateExcludedFolders((Module)module, (VirtualFile)contentRoot, oldToUpdateFolders, newToUpdateFolders);
    }

    private void excludePlatformFolders() {
        Collection platformsFolders = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"platforms", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
        for (VirtualFile platformFolder : platformsFolders) {
            PhoneGapProjectComponent.excludePlatformFolder(this.myProject, platformFolder);
        }
    }

    public static void excludePlatformFolder(Project project, VirtualFile platformFolder) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)platformFolder, (Project)project);
        if (module == null) {
            return;
        }
        VirtualFile contentRoot = PhoneGapProjectComponent.getContentRoot(module, platformFolder);
        if (contentRoot == null) {
            return;
        }
        Collection<String> oldExcludedFolders = PhoneGapProjectComponent.getOldExcludedFolders(module, platformFolder);
        if (oldExcludedFolders.size() == 1 && oldExcludedFolders.contains(platformFolder.getUrl())) {
            return;
        }
        ModuleRootModificationUtil.updateExcludedFolders((Module)module, (VirtualFile)contentRoot, oldExcludedFolders, (Collection)ContainerUtil.newHashSet((Object[])new String[]{platformFolder.getUrl()}));
    }

    private static Collection<String> getOldExcludedFolders(Module module, VirtualFile root) {
        return ContainerUtil.filter((Object[])ModuleRootManager.getInstance((Module)module).getExcludeRootUrls(), url -> url.startsWith(root.getUrl()));
    }

    private static VirtualFile getContentRoot(Module module, VirtualFile root) {
        return root == null ? null : ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getContentRootForFile(root);
    }
}

