/*
 * Decompiled with CFR 0.152.
 */
package com.github.masahirosuzuka.PhoneGapIntelliJPlugin;

import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.PhoneGapBundle;
import com.github.masahirosuzuka.PhoneGapIntelliJPlugin.settings.PhoneGapSettings;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhoneGapUtil {
    public static final String FOLDER_PLATFORMS = "platforms";
    public static final String FOLDER_WWW = "www";
    public static final String FOLDER_CORDOVA = ".cordova";
    public static final String FOLDER_PLUGINS = "plugins";
    public static final String[] POSSIBLE_FOLDERS_IN_PHONEGAP_ROOT = new String[]{"platforms", "plugins", "www"};

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createPhoneGapExecutableTextField(@Nullable Project project) {
        TextFieldWithHistoryWithBrowseButton field = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)PhoneGapBundle.message("phonegap.conf.executable.name", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), () -> PhoneGapUtil.getDefaultExecutablePaths());
        String executablePath = PhoneGapSettings.getInstance().getExecutablePath();
        PhoneGapUtil.setDefaultValue(field, executablePath);
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = field;
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "createPhoneGapExecutableTextField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createPhoneGapWorkingDirectoryField(@Nullable Project project) {
        TextFieldWithHistoryWithBrowseButton field = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)PhoneGapBundle.message("phonegap.conf.work.dir.name", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), () -> PhoneGapUtil.getDefaultWorkingDirectory(project));
        PhoneGapUtil.setDefaultValue(field, PhoneGapSettings.getInstance().getWorkingDirectory(project));
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = field;
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "createPhoneGapWorkingDirectoryField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    public static void setFieldWithHistoryWithBrowseButtonPath(@NotNull TextFieldWithHistoryWithBrowseButton field, @Nullable String executablePath) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "setFieldWithHistoryWithBrowseButtonPath"));
        }
        PhoneGapUtil.setDefaultValue(field, executablePath);
    }

    @NotNull
    public static List<String> getDefaultExecutablePaths() {
        ArrayList paths = ContainerUtil.newArrayList();
        ContainerUtil.addIfNotNull((Collection)paths, (Object)PhoneGapUtil.getPath("phonegap"));
        ContainerUtil.addIfNotNull((Collection)paths, (Object)PhoneGapUtil.getPath("ionic"));
        ContainerUtil.addIfNotNull((Collection)paths, (Object)PhoneGapUtil.getPath("cordova"));
        ArrayList arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "getDefaultExecutablePaths"));
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getDefaultWorkingDirectory(@Nullable Project project) {
        ArrayList paths = ContainerUtil.newArrayList();
        if (project == null) {
            ArrayList arrayList = paths;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "getDefaultWorkingDirectory"));
            }
            return arrayList;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            ArrayList arrayList = paths;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "getDefaultWorkingDirectory"));
            }
            return arrayList;
        }
        if (PhoneGapUtil.folderExist(baseDir, FOLDER_PLATFORMS) || PhoneGapUtil.folderExist(baseDir, FOLDER_WWW) || PhoneGapUtil.folderExist(baseDir, FOLDER_CORDOVA)) {
            ContainerUtil.addIfNotNull((Collection)paths, (Object)project.getBasePath());
        } else {
            PhoneGapUtil.addPaths(paths, PhoneGapUtil.getFolders(project));
        }
        ArrayList arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "getDefaultWorkingDirectory"));
        }
        return arrayList;
    }

    private static boolean folderExist(VirtualFile baseDir, String name) {
        VirtualFile child = baseDir.findChild(name);
        return child != null && child.isDirectory();
    }

    private static void setDefaultValue(@NotNull TextFieldWithHistoryWithBrowseButton field, @Nullable String defaultValue) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "setDefaultValue"));
        }
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)field.getChildComponent();
        if (StringUtil.isNotEmpty((String)defaultValue)) {
            PhoneGapUtil.setTextFieldWithHistory(textFieldWithHistory, defaultValue);
        }
    }

    public static void setTextFieldWithHistory(TextFieldWithHistory textFieldWithHistory, String value) {
        if (null != value) {
            textFieldWithHistory.setText(value);
            textFieldWithHistory.addCurrentTextToHistory();
        }
    }

    private static Collection<VirtualFile> getFolders(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "getFolders"));
        }
        for (String folder : POSSIBLE_FOLDERS_IN_PHONEGAP_ROOT) {
            List files = ContainerUtil.filter((Collection)FilenameIndex.getVirtualFilesByName((Project)project, (String)folder, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)), file -> file.isDirectory());
            if (files.isEmpty()) continue;
            return files;
        }
        return ContainerUtil.emptyList();
    }

    private static void addPaths(@NotNull List<String> paths, @NotNull Collection<VirtualFile> platforms) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "addPaths"));
        }
        if (platforms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FOLDER_PLATFORMS, "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "addPaths"));
        }
        for (VirtualFile platform : platforms) {
            ContainerUtil.addIfNotNull(paths, (Object)platform.getParent().getPath());
        }
    }

    @Nullable
    private static String getPath(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "getPath"));
        }
        File path = PathEnvironmentVariableUtil.findInPath((String)(SystemInfo.isWindows ? name + ".cmd" : name));
        return path != null && path.exists() ? path.getAbsolutePath() : null;
    }

    public static boolean isPhoneGapProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "isPhoneGapProject"));
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/masahirosuzuka/PhoneGapIntelliJPlugin/PhoneGapUtil", "lambda$isPhoneGapProject$4"));
            }
            Object[] files = FilenameIndex.getFilesByName((Project)project, (String)"config.xml", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            PsiFile matchedFile = (PsiFile)ContainerUtil.find((Object[])files, psiFile -> {
                if (!(psiFile instanceof XmlFile)) {
                    return false;
                }
                XmlTag root = ((XmlFile)psiFile).getRootTag();
                if (root == null) {
                    return false;
                }
                return root.getName().equals("widget");
            });
            if (matchedFile != null) {
                return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{matchedFile});
            }
            if (files.length > 0) {
                Object[] append = ArrayUtil.append((Object[])files, (Object)VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, Object.class);
                return CachedValueProvider.Result.create((Object)false, (Object[])append);
            }
            return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootModificationTracker.getInstance((Project)project)});
        });
    }
}

